/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.replanning.modules;

import javax.inject.Provider;
import org.matsim.core.config.groups.GlobalConfigGroup;
import org.matsim.core.population.algorithms.PlanAlgorithm;
import org.matsim.core.population.algorithms.TripsToLegsAlgorithm;
import org.matsim.core.replanning.modules.AbstractMultithreadedModule;
import org.matsim.core.router.CompositeStageActivityTypes;
import org.matsim.core.router.StageActivityTypes;
import org.matsim.core.router.TripRouter;

public class TripsToLegsModule
extends AbstractMultithreadedModule {
    private final StageActivityTypes additionalBlackList;
    private final Provider<TripRouter> tripRouterProvider;

    public TripsToLegsModule(Provider<TripRouter> tripRouterProvider, GlobalConfigGroup globalConfigGroup) {
        this(null, tripRouterProvider, globalConfigGroup);
    }

    public TripsToLegsModule(StageActivityTypes additionalBlackList, Provider<TripRouter> tripRouterProvider, GlobalConfigGroup globalConfigGroup) {
        super(globalConfigGroup);
        this.tripRouterProvider = tripRouterProvider;
        this.additionalBlackList = additionalBlackList;
    }

    @Override
    public PlanAlgorithm getPlanAlgoInstance() {
        TripRouter router = this.tripRouterProvider.get();
        StageActivityTypes blackListToUse = router.getStageActivityTypes();
        if (this.additionalBlackList != null) {
            CompositeStageActivityTypes composite = new CompositeStageActivityTypes();
            composite.addActivityTypes(blackListToUse);
            composite.addActivityTypes(this.additionalBlackList);
            blackListToUse = composite;
        }
        return new TripsToLegsAlgorithm(blackListToUse, router.getMainModeIdentifier());
    }
}

