/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.replanning.selectors;

import java.util.List;
import java.util.Map;
import org.matsim.api.core.v01.population.HasPlansAndId;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.core.gbl.MatsimRandom;
import org.matsim.core.replanning.selectors.PlanSelector;
import org.matsim.core.replanning.selectors.RandomUnscoredPlanSelector;

public abstract class AbstractPlanSelector
implements PlanSelector<Plan, Person> {
    @Override
    public final Plan selectPlan(HasPlansAndId<Plan, Person> person) {
        Plan selectedPlan = new RandomUnscoredPlanSelector<Plan, Person>().selectPlan(person);
        if (selectedPlan != null) {
            return selectedPlan;
        }
        Map<Plan, Double> wc = this.calcWeights(person.getPlans());
        double sumWeights = 0.0;
        for (Double score : wc.values()) {
            sumWeights += score.doubleValue();
        }
        double selnum = sumWeights * MatsimRandom.getRandom().nextDouble();
        for (Plan plan : person.getPlans()) {
            if (!((selnum -= wc.get(plan).doubleValue()) <= 0.0)) continue;
            return plan;
        }
        return null;
    }

    protected abstract Map<Plan, Double> calcWeights(List<? extends Plan> var1);
}

