/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.replanning.selectors;

import org.matsim.api.core.v01.population.BasicPlan;
import org.matsim.api.core.v01.population.HasPlansAndId;
import org.matsim.core.replanning.selectors.PlanSelector;

public class BestPlanSelector<T extends BasicPlan, I>
implements PlanSelector<T, I> {
    @Override
    public T selectPlan(HasPlansAndId<T, I> person) {
        double maxScore = Double.NEGATIVE_INFINITY;
        BasicPlan bestPlan = null;
        for (BasicPlan plan : person.getPlans()) {
            Double score = plan.getScore();
            if (score == null || !(score > maxScore) || score.isNaN()) continue;
            maxScore = plan.getScore();
            bestPlan = plan;
        }
        if (bestPlan == null && person.getPlans().size() > 0) {
            return (T)((BasicPlan)person.getPlans().get(0));
        }
        return (T)bestPlan;
    }
}

