/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.replanning.selectors;

import org.apache.log4j.Logger;
import org.matsim.api.core.v01.population.BasicPlan;
import org.matsim.api.core.v01.population.HasPlansAndId;
import org.matsim.core.gbl.MatsimRandom;
import org.matsim.core.replanning.selectors.PlanSelector;
import org.matsim.core.replanning.selectors.RandomPlanSelector;

public final class ExpBetaPlanChanger<T extends BasicPlan, I>
implements PlanSelector<T, I> {
    private static final Logger log = Logger.getLogger(ExpBetaPlanChanger.class);
    private final double beta;
    static boolean betaWrnFlag = true;
    static boolean scoreWrnFlag = true;

    public ExpBetaPlanChanger(double beta) {
        this.beta = beta;
    }

    @Override
    public T selectPlan(HasPlansAndId<T, I> person) {
        T currentPlan = person.getSelectedPlan();
        Object otherPlan = new RandomPlanSelector<T, I>().selectPlan(person);
        if (currentPlan == null) {
            return null;
        }
        if (currentPlan.getScore() == null || otherPlan.getScore() == null) {
            if (currentPlan.getScore() != null && otherPlan.getScore() == null && scoreWrnFlag) {
                log.error("yyyyyy not switching to other plan although it needs to be explored.  Possibly a serious bug; ask kai if you encounter this.  kai, sep'10");
                scoreWrnFlag = false;
            }
            return currentPlan;
        }
        if (currentPlan.getScore().isNaN()) {
            return otherPlan;
        }
        if (otherPlan.getScore().isNaN()) {
            return currentPlan;
        }
        double currentScore = currentPlan.getScore();
        double otherScore = otherPlan.getScore();
        if (betaWrnFlag) {
            log.warn("Would make sense to revise this once more.  See comments in code.  kai, nov08");
            betaWrnFlag = false;
        }
        double weight = Math.exp(0.5 * this.beta * (otherScore - currentScore));
        if (MatsimRandom.getRandom().nextDouble() < 0.01 * weight) {
            return otherPlan;
        }
        return currentPlan;
    }
}

