/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.replanning.selectors;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.population.BasicPlan;
import org.matsim.api.core.v01.population.HasPlansAndId;
import org.matsim.core.config.groups.PlanCalcScoreConfigGroup;
import org.matsim.core.gbl.MatsimRandom;
import org.matsim.core.replanning.selectors.PlanSelector;

public class ExpBetaPlanSelector<T extends BasicPlan, I>
implements PlanSelector<T, I> {
    protected static final double MIN_WEIGHT = Double.MIN_VALUE;
    protected final double beta;

    public ExpBetaPlanSelector(double logitScaleFactor) {
        this.beta = logitScaleFactor;
    }

    public ExpBetaPlanSelector(PlanCalcScoreConfigGroup charyparNagelScoringConfigGroup) {
        this(charyparNagelScoringConfigGroup.getBrainExpBeta());
    }

    @Override
    public T selectPlan(HasPlansAndId<T, I> person) {
        Map<T, Double> weights = this.calcWeights(person);
        double sumWeights = 0.0;
        for (Double weight : weights.values()) {
            sumWeights += weight.doubleValue();
        }
        double selnum = sumWeights * MatsimRandom.getRandom().nextDouble();
        for (BasicPlan plan : person.getPlans()) {
            if (!((selnum -= weights.get(plan).doubleValue()) <= 0.0)) continue;
            return (T)plan;
        }
        if (person.getPlans().size() > 0) {
            return (T)((BasicPlan)person.getPlans().get(0));
        }
        return null;
    }

    protected double calcPlanWeight(T plan, double maxScore) {
        if (plan.getScore() == null) {
            return Double.NaN;
        }
        double weight = Math.exp(this.beta * (plan.getScore() - maxScore));
        if (weight < Double.MIN_VALUE) {
            weight = Double.MIN_VALUE;
        }
        return weight;
    }

    Map<T, Double> calcWeights(HasPlansAndId<T, ?> person) {
        double maxScore = Double.NEGATIVE_INFINITY;
        for (BasicPlan plan1 : person.getPlans()) {
            if (plan1.getScore() != null && plan1.getScore().isNaN()) {
                Logger.getLogger(this.getClass()).error("encountering getScore().isNaN().  This class is not well behaved in this situation.  Continuing anyway ...");
            }
            if (plan1.getScore() == null || !(plan1.getScore() > maxScore)) continue;
            maxScore = plan1.getScore();
        }
        LinkedHashMap<BasicPlan, Double> weights = new LinkedHashMap<BasicPlan, Double>(person.getPlans().size());
        for (BasicPlan plan : person.getPlans()) {
            weights.put(plan, this.calcPlanWeight(plan, maxScore));
        }
        return weights;
    }

    public static <T extends BasicPlan, I> double getSelectionProbability(ExpBetaPlanSelector<T, I> expBetaPlanSelector, HasPlansAndId<T, ?> person, T plan) {
        Map<T, Double> weights = expBetaPlanSelector.calcWeights(person);
        double thisWeight = weights.get(plan);
        double sumWeights = 0.0;
        for (Double weight : weights.values()) {
            sumWeights += weight.doubleValue();
        }
        return thisWeight / sumWeights;
    }
}

