/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.replanning.selectors;

import org.matsim.api.core.v01.population.BasicPlan;
import org.matsim.api.core.v01.population.HasPlansAndId;
import org.matsim.core.replanning.selectors.PlanSelector;

public class GenericWorstPlanForRemovalSelector<T extends BasicPlan, I>
implements PlanSelector<T, I> {
    private static final String UNDEFINED_TYPE = "undefined";

    @Override
    public T selectPlan(HasPlansAndId<T, I> person) {
        BasicPlan worst = null;
        double worstScore = Double.POSITIVE_INFINITY;
        for (BasicPlan plan : person.getPlans()) {
            if (plan.getScore() == null || plan.getScore().isNaN()) {
                worst = plan;
                worstScore = Double.NEGATIVE_INFINITY;
                continue;
            }
            if (!(plan.getScore() < worstScore)) continue;
            worst = plan;
            worstScore = plan.getScore();
        }
        if (worst == null) {
            for (BasicPlan plan : person.getPlans()) {
                if (plan.getScore() == null || plan.getScore().isNaN()) {
                    return (T)plan;
                }
                if (!(plan.getScore() < worstScore)) continue;
                worst = plan;
                worstScore = plan.getScore();
            }
        }
        return (T)worst;
    }
}

