/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.replanning.selectors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.api.core.v01.population.PlanElement;
import org.matsim.core.config.groups.PlanCalcScoreConfigGroup;
import org.matsim.core.population.routes.NetworkRoute;
import org.matsim.core.population.routes.RouteUtils;
import org.matsim.core.replanning.selectors.AbstractPlanSelector;

public final class PathSizeLogitSelector
extends AbstractPlanSelector {
    private final double pathSizeLogitExponent;
    private final double logitScaleFactor;
    private Network network;

    public PathSizeLogitSelector(double pathSizeLogitExponent, double logitScaleFactor, Network network) {
        this.pathSizeLogitExponent = pathSizeLogitExponent;
        this.logitScaleFactor = logitScaleFactor;
        this.network = network;
    }

    public PathSizeLogitSelector(PlanCalcScoreConfigGroup config, Network network) {
        this(config.getPathSizeLogitBeta(), config.getBrainExpBeta(), network);
    }

    @Override
    protected Map<Plan, Double> calcWeights(List<? extends Plan> plans) {
        HashMap<Plan, Double> weights = new HashMap<Plan, Double>();
        double maxScore = Double.NEGATIVE_INFINITY;
        HashMap<Id<Link>, ArrayList<Double>> linksInTime = new HashMap<Id<Link>, ArrayList<Double>>();
        HashMap<Integer, Double> planLength = new HashMap<Integer, Double>();
        for (Plan plan : plans) {
            if (plan.getScore() > maxScore) {
                maxScore = plan.getScore();
            }
            double pathSize = 0.0;
            double currentEndTime = 0.0;
            for (PlanElement pe : plan.getPlanElements()) {
                if (!(pe instanceof Leg)) continue;
                Leg leg = (Leg)pe;
                currentEndTime = leg.getDepartureTime();
                NetworkRoute r = (NetworkRoute)leg.getRoute();
                pathSize += RouteUtils.calcDistanceExcludingStartEndLink(r, this.network);
                for (Id<Link> linkId : r.getLinkIds()) {
                    ArrayList<Double> lit = (ArrayList<Double>)linksInTime.get(linkId);
                    if (lit == null) {
                        lit = new ArrayList<Double>();
                        linksInTime.put(linkId, lit);
                    }
                    lit.add(currentEndTime);
                }
            }
            planLength.put(plan.hashCode(), pathSize);
        }
        for (Plan plan : plans) {
            double tmp = 0.0;
            for (PlanElement pe : plan.getPlanElements()) {
                if (!(pe instanceof Leg)) continue;
                Leg leg = (Leg)pe;
                double currentTime = leg.getDepartureTime();
                NetworkRoute route = (NetworkRoute)leg.getRoute();
                for (Id<Link> linkId : route.getLinkIds()) {
                    double denominator = 0.0;
                    Iterator iterator = ((ArrayList)linksInTime.get(linkId)).iterator();
                    while (iterator.hasNext()) {
                        double dbl = (Double)iterator.next();
                        if (!(Math.abs(dbl - currentTime) <= 3600.0)) continue;
                        denominator += 1.0;
                    }
                    Link link = this.network.getLinks().get(linkId);
                    tmp += link.getLength() / denominator;
                }
            }
            double PSi = Math.pow(tmp / (Double)planLength.get(plan.hashCode()), this.pathSizeLogitExponent);
            double weight = Double.isInfinite(maxScore) ? PSi : Math.exp(this.logitScaleFactor * (plan.getScore() - maxScore)) * PSi;
            if (weight <= 0.0) {
                weight = 0.0;
            }
            weights.put(plan, weight);
        }
        return weights;
    }
}

