/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.replanning.selectors;

import org.matsim.api.core.v01.population.BasicPlan;
import org.matsim.api.core.v01.population.HasPlansAndId;
import org.matsim.core.gbl.MatsimRandom;
import org.matsim.core.replanning.selectors.PlanSelector;

public class RandomUnscoredPlanSelector<T extends BasicPlan, I>
implements PlanSelector<T, I> {
    @Override
    public T selectPlan(HasPlansAndId<T, I> person) {
        int cntUnscored = 0;
        for (BasicPlan plan : person.getPlans()) {
            if (plan.getScore() != null) continue;
            ++cntUnscored;
        }
        if (cntUnscored > 0) {
            int idxUnscored = MatsimRandom.getRandom().nextInt(cntUnscored);
            cntUnscored = 0;
            for (BasicPlan plan : person.getPlans()) {
                if (plan.getScore() != null) continue;
                if (cntUnscored == idxUnscored) {
                    return (T)plan;
                }
                ++cntUnscored;
            }
        }
        return null;
    }
}

