/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.replanning.selectors;

import java.util.concurrent.ConcurrentHashMap;
import org.matsim.api.core.v01.population.HasPlansAndId;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.core.replanning.selectors.PlanSelector;

public class WorstPlanForRemovalSelector
implements PlanSelector<Plan, Person> {
    private static final String UNDEFINED_TYPE = "undefined";

    @Override
    public Plan selectPlan(HasPlansAndId<Plan, Person> person) {
        ConcurrentHashMap<String, Integer> typeCounts = new ConcurrentHashMap<String, Integer>();
        for (Plan plan : person.getPlans()) {
            String type = plan.getType();
            if (type == null) {
                type = UNDEFINED_TYPE;
            }
            typeCounts.merge(type, 1, (a, b) -> a + b);
        }
        Plan worst = null;
        double worstScore = Double.POSITIVE_INFINITY;
        for (Plan plan : person.getPlans()) {
            String type = plan.getType();
            if (type == null) {
                type = UNDEFINED_TYPE;
            }
            if ((Integer)typeCounts.get(type) <= 1) continue;
            if (plan.getScore() == null || plan.getScore().isNaN()) {
                worst = plan;
                worstScore = Double.NEGATIVE_INFINITY;
                continue;
            }
            if (!(plan.getScore() < worstScore)) continue;
            worst = plan;
            worstScore = plan.getScore();
        }
        if (worst == null) {
            for (Plan plan : person.getPlans()) {
                if (plan.getScore() == null || plan.getScore().isNaN()) {
                    return plan;
                }
                if (!(plan.getScore() < worstScore)) continue;
                worst = plan;
                worstScore = plan.getScore();
            }
        }
        return worst;
    }
}

