/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.replanning.strategies;

import javax.inject.Inject;
import javax.inject.Provider;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.core.config.groups.ChangeModeConfigGroup;
import org.matsim.core.config.groups.GlobalConfigGroup;
import org.matsim.core.replanning.PlanStrategy;
import org.matsim.core.replanning.PlanStrategyImpl;
import org.matsim.core.replanning.modules.ChangeSingleLegMode;
import org.matsim.core.replanning.modules.ReRoute;
import org.matsim.core.replanning.modules.TripsToLegsModule;
import org.matsim.core.replanning.selectors.RandomPlanSelector;
import org.matsim.core.router.TripRouter;
import org.matsim.facilities.ActivityFacilities;

public class ChangeSingleTripMode
implements Provider<PlanStrategy> {
    private final GlobalConfigGroup globalConfigGroup;
    private final ChangeModeConfigGroup changeLegModeConfigGroup;
    private Provider<TripRouter> tripRouterProvider;
    private ActivityFacilities activityFacilities;

    @Inject
    ChangeSingleTripMode(GlobalConfigGroup globalConfigGroup, ChangeModeConfigGroup changeLegModeConfigGroup, ActivityFacilities activityFacilities, Provider<TripRouter> tripRouterProvider) {
        this.globalConfigGroup = globalConfigGroup;
        this.changeLegModeConfigGroup = changeLegModeConfigGroup;
        this.activityFacilities = activityFacilities;
        this.tripRouterProvider = tripRouterProvider;
    }

    @Override
    public PlanStrategy get() {
        PlanStrategyImpl.Builder builder = new PlanStrategyImpl.Builder(new RandomPlanSelector<Plan, Person>());
        builder.addStrategyModule(new TripsToLegsModule(this.tripRouterProvider, this.globalConfigGroup));
        builder.addStrategyModule(new ChangeSingleLegMode(this.globalConfigGroup, this.changeLegModeConfigGroup));
        builder.addStrategyModule(new ReRoute(this.activityFacilities, this.tripRouterProvider, this.globalConfigGroup));
        return builder.build();
    }
}

