/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.replanning.strategies;

import com.google.inject.TypeLiteral;
import java.util.HashSet;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.core.config.groups.PlanCalcScoreConfigGroup;
import org.matsim.core.config.groups.StrategyConfigGroup;
import org.matsim.core.controler.AbstractModule;
import org.matsim.core.replanning.selectors.ExpBetaPlanChanger;
import org.matsim.core.replanning.selectors.ExpBetaPlanSelector;
import org.matsim.core.replanning.selectors.PathSizeLogitSelector;
import org.matsim.core.replanning.selectors.PlanSelector;
import org.matsim.core.replanning.selectors.RandomPlanSelector;
import org.matsim.core.replanning.selectors.WorstPlanForRemovalSelector;
import org.matsim.core.replanning.strategies.ChangeExpBeta;
import org.matsim.core.replanning.strategies.ChangeSingleTripMode;
import org.matsim.core.replanning.strategies.ChangeTripMode;
import org.matsim.core.replanning.strategies.KeepLastSelected;
import org.matsim.core.replanning.strategies.ReRoute;
import org.matsim.core.replanning.strategies.SelectBest;
import org.matsim.core.replanning.strategies.SelectExpBeta;
import org.matsim.core.replanning.strategies.SelectPathSizeLogit;
import org.matsim.core.replanning.strategies.SelectRandom;
import org.matsim.core.replanning.strategies.SubtourModeChoice;
import org.matsim.core.replanning.strategies.TimeAllocationMutator;
import org.matsim.core.replanning.strategies.TimeAllocationMutatorReRoute;

public class DefaultPlanStrategiesModule
extends AbstractModule {
    private static final Logger log = Logger.getLogger(DefaultPlanStrategiesModule.class);

    @Override
    public void install() {
        if (this.getConfig().strategy().getPlanSelectorForRemoval().equals(DefaultPlansRemover.WorstPlanSelector.toString())) {
            this.bindPlanSelectorForRemoval().to(WorstPlanForRemovalSelector.class);
        }
        if (this.getConfig().strategy().getPlanSelectorForRemoval().equals(DefaultPlansRemover.SelectRandom.toString())) {
            this.bindPlanSelectorForRemoval().to((TypeLiteral<PlanSelector<Plan, Person>>)new TypeLiteral<RandomPlanSelector<Plan, Person>>(){});
        }
        if (this.getConfig().strategy().getPlanSelectorForRemoval().equals(DefaultPlansRemover.SelectExpBetaForRemoval.toString())) {
            this.bindPlanSelectorForRemoval().toProvider(ExpBetaPlanSelectorForRemoval.class);
        }
        if (this.getConfig().strategy().getPlanSelectorForRemoval().equals(DefaultPlansRemover.ChangeExpBetaForRemoval.toString())) {
            this.bindPlanSelectorForRemoval().toProvider(ExpBetaPlanChangerForRemoval.class);
        }
        if (this.getConfig().strategy().getPlanSelectorForRemoval().equals(DefaultPlansRemover.PathSizeLogitSelectorForRemoval.toString())) {
            this.bindPlanSelectorForRemoval().toProvider(PathSizeLogitSelectorForRemoval.class);
        }
        HashSet<String> usedStrategyNames = new HashSet<String>();
        for (StrategyConfigGroup.StrategySettings settings : this.getConfig().strategy().getStrategySettings()) {
            usedStrategyNames.add(settings.getStrategyName());
        }
        if (usedStrategyNames.contains("KeepLastSelected")) {
            this.addPlanStrategyBinding("KeepLastSelected").toProvider(KeepLastSelected.class);
        }
        if (usedStrategyNames.contains("BestScore")) {
            this.addPlanStrategyBinding("BestScore").toProvider(SelectBest.class);
        }
        if (usedStrategyNames.contains("SelectExpBeta")) {
            this.addPlanStrategyBinding("SelectExpBeta").toProvider(SelectExpBeta.class);
        }
        if (usedStrategyNames.contains("ChangeExpBeta")) {
            this.addPlanStrategyBinding("ChangeExpBeta").toProvider(ChangeExpBeta.class);
        }
        if (usedStrategyNames.contains("SelectRandom")) {
            this.addPlanStrategyBinding("SelectRandom").toProvider(SelectRandom.class);
        }
        if (usedStrategyNames.contains("SelectPathSizeLogit")) {
            this.addPlanStrategyBinding("SelectPathSizeLogit").toProvider(SelectPathSizeLogit.class);
        }
        if (usedStrategyNames.contains("ReRoute")) {
            this.addPlanStrategyBinding("ReRoute").toProvider(ReRoute.class);
        }
        if (usedStrategyNames.contains("TimeAllocationMutator")) {
            this.addPlanStrategyBinding("TimeAllocationMutator").toProvider(TimeAllocationMutator.class);
        }
        if (usedStrategyNames.contains("TimeAllocationMutator_ReRoute")) {
            this.addPlanStrategyBinding("TimeAllocationMutator_ReRoute").toProvider(TimeAllocationMutatorReRoute.class);
        }
        if (usedStrategyNames.contains("SubtourModeChoice")) {
            this.addPlanStrategyBinding("SubtourModeChoice").toProvider(SubtourModeChoice.class);
        }
        if (usedStrategyNames.contains("ChangeTripMode")) {
            this.addPlanStrategyBinding("ChangeTripMode").toProvider(ChangeTripMode.class);
        }
        if (usedStrategyNames.contains("ChangeSingleTripMode")) {
            this.addPlanStrategyBinding("ChangeSingleTripMode").toProvider(ChangeSingleTripMode.class);
        }
        if (usedStrategyNames.contains("ChangeLegMode")) {
            log.error("ChangeLegMode replanning strategy does not exist anymore. Please use ChangeTripMode instead.");
        }
        if (usedStrategyNames.contains("ChangeSingleLegMode")) {
            log.error("ChangeSingleLegMode replanning strategy does not exist anymore. Please use ChangeSingleTripMode instead.");
        }
        if (usedStrategyNames.contains("TripSubtourModeChoice")) {
            log.error("TripSubtourModeChoice replanning strategy does not exist anymore. Please use SubtourModeChoice instead.");
        }
    }

    private static class PathSizeLogitSelectorForRemoval
    implements Provider<PathSizeLogitSelector> {
        @Inject
        PlanCalcScoreConfigGroup config;
        @Inject
        Network network;

        private PathSizeLogitSelectorForRemoval() {
        }

        @Override
        public PathSizeLogitSelector get() {
            return new PathSizeLogitSelector(this.config.getPathSizeLogitBeta(), -this.config.getBrainExpBeta(), this.network);
        }
    }

    private static class ExpBetaPlanChangerForRemoval
    implements Provider<ExpBetaPlanChanger<Plan, Person>> {
        @Inject
        private PlanCalcScoreConfigGroup config;

        private ExpBetaPlanChangerForRemoval() {
        }

        @Override
        public ExpBetaPlanChanger<Plan, Person> get() {
            return new ExpBetaPlanChanger<Plan, Person>(-this.config.getBrainExpBeta());
        }
    }

    private static class ExpBetaPlanSelectorForRemoval
    implements Provider<ExpBetaPlanSelector<Plan, Person>> {
        @Inject
        private PlanCalcScoreConfigGroup config;

        private ExpBetaPlanSelectorForRemoval() {
        }

        @Override
        public ExpBetaPlanSelector<Plan, Person> get() {
            return new ExpBetaPlanSelector<Plan, Person>(-this.config.getBrainExpBeta());
        }
    }

    public static interface DefaultStrategy {
        public static final String ReRoute = "ReRoute";
        public static final String TimeAllocationMutator = "TimeAllocationMutator";
        @Deprecated
        public static final String ChangeLegMode = "ChangeLegMode";
        public static final String TimeAllocationMutator_ReRoute = "TimeAllocationMutator_ReRoute";
        @Deprecated
        public static final String ChangeSingleLegMode = "ChangeSingleLegMode";
        public static final String ChangeSingleTripMode = "ChangeSingleTripMode";
        public static final String SubtourModeChoice = "SubtourModeChoice";
        public static final String ChangeTripMode = "ChangeTripMode";
        @Deprecated
        public static final String TripSubtourModeChoice = "TripSubtourModeChoice";
    }

    public static interface DefaultSelector {
        public static final String KeepLastSelected = "KeepLastSelected";
        public static final String BestScore = "BestScore";
        public static final String ChangeExpBeta = "ChangeExpBeta";
        public static final String SelectExpBeta = "SelectExpBeta";
        public static final String SelectRandom = "SelectRandom";
        public static final String SelectPathSizeLogit = "SelectPathSizeLogit";
    }

    public static enum DefaultPlansRemover {
        WorstPlanSelector,
        SelectRandom,
        SelectExpBetaForRemoval,
        ChangeExpBetaForRemoval,
        PathSizeLogitSelectorForRemoval;

    }
}

