/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.replanning.strategies;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Provider;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.population.Population;
import org.matsim.core.config.Config;
import org.matsim.core.config.ConfigGroup;
import org.matsim.core.config.groups.GlobalConfigGroup;
import org.matsim.core.config.groups.PlansConfigGroup;
import org.matsim.core.config.groups.TimeAllocationMutatorConfigGroup;
import org.matsim.core.gbl.MatsimRandom;
import org.matsim.core.population.algorithms.PlanAlgorithm;
import org.matsim.core.population.algorithms.PlanMutateTimeAllocationSimplified;
import org.matsim.core.population.algorithms.TripPlanMutateTimeAllocation;
import org.matsim.core.replanning.modules.AbstractMultithreadedModule;
import org.matsim.core.router.TripRouter;

class TimeAllocationMutatorModule
extends AbstractMultithreadedModule {
    private static final Logger log = Logger.getLogger(TimeAllocationMutatorModule.class);
    private final Provider<TripRouter> tripRouterProvider;
    private final double mutationRange;
    private final boolean affectingDuration;
    private final String subpopulationAttribute;
    private final Map<String, Double> subpopulationMutationRanges;
    private final Map<String, Boolean> subpopulationAffectingDuration;
    private final PlansConfigGroup.ActivityDurationInterpretation activityDurationInterpretation;

    @Deprecated
    TimeAllocationMutatorModule(Config config, Provider<TripRouter> tripRouterProvider, double mutationRange, boolean affectingDuration) {
        super(config.global());
        this.tripRouterProvider = tripRouterProvider;
        this.affectingDuration = affectingDuration;
        this.mutationRange = mutationRange;
        this.activityDurationInterpretation = config.plans().getActivityDurationInterpretation();
        this.subpopulationAttribute = null;
        this.subpopulationMutationRanges = null;
        this.subpopulationAffectingDuration = null;
        log.warn("deprecated constructor was used - individual time allocation mutator settings for subpopulations is not supported!");
    }

    TimeAllocationMutatorModule(Provider<TripRouter> tripRouterProvider, PlansConfigGroup plansConfigGroup, TimeAllocationMutatorConfigGroup timeAllocationMutatorConfigGroup, GlobalConfigGroup globalConfigGroup) {
        this(tripRouterProvider, plansConfigGroup, timeAllocationMutatorConfigGroup, globalConfigGroup, null);
    }

    TimeAllocationMutatorModule(Provider<TripRouter> tripRouterProvider, PlansConfigGroup plansConfigGroup, TimeAllocationMutatorConfigGroup timeAllocationMutatorConfigGroup, GlobalConfigGroup globalConfigGroup, Population population) {
        super(globalConfigGroup);
        this.tripRouterProvider = tripRouterProvider;
        this.activityDurationInterpretation = plansConfigGroup.getActivityDurationInterpretation();
        this.mutationRange = timeAllocationMutatorConfigGroup.getMutationRange();
        this.affectingDuration = timeAllocationMutatorConfigGroup.isAffectingDuration();
        if (plansConfigGroup.getSubpopulationAttributeName() != null && timeAllocationMutatorConfigGroup.isUseIndividualSettingsForSubpopulations() && population != null) {
            this.subpopulationAttribute = plansConfigGroup.getSubpopulationAttributeName();
            this.subpopulationMutationRanges = new HashMap<String, Double>();
            this.subpopulationAffectingDuration = new HashMap<String, Boolean>();
            Collection<? extends ConfigGroup> settings = timeAllocationMutatorConfigGroup.getParameterSets("subpopulationSettings");
            for (ConfigGroup configGroup : settings) {
                TimeAllocationMutatorConfigGroup.TimeAllocationMutatorSubpopulationSettings subpopulationSettings = (TimeAllocationMutatorConfigGroup.TimeAllocationMutatorSubpopulationSettings)configGroup;
                String subpopulation = subpopulationSettings.getSubpopulation();
                this.subpopulationMutationRanges.put(subpopulation, subpopulationSettings.getMutationRange());
                this.subpopulationAffectingDuration.put(subpopulation, subpopulationSettings.isAffectingDuration());
                log.info("Found individual time mutator settings for subpopulation: " + subpopulation);
            }
        } else {
            this.subpopulationAttribute = null;
            this.subpopulationMutationRanges = null;
            this.subpopulationAffectingDuration = null;
        }
    }

    @Override
    public PlanAlgorithm getPlanAlgoInstance() {
        PlanAlgorithm pmta;
        switch (this.activityDurationInterpretation) {
            case minOfDurationAndEndTime: {
                pmta = new TripPlanMutateTimeAllocation(this.tripRouterProvider.get().getStageActivityTypes(), this.mutationRange, this.affectingDuration, MatsimRandom.getLocalInstance(), this.subpopulationAttribute, this.subpopulationMutationRanges, this.subpopulationAffectingDuration);
                break;
            }
            default: {
                pmta = new PlanMutateTimeAllocationSimplified(this.tripRouterProvider.get().getStageActivityTypes(), this.mutationRange, this.affectingDuration, MatsimRandom.getLocalInstance());
            }
        }
        return pmta;
    }
}

