/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.router;

import org.apache.log4j.Logger;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.Node;
import org.matsim.core.router.Dijkstra;
import org.matsim.core.router.util.AStarNodeData;
import org.matsim.core.router.util.DijkstraNodeData;
import org.matsim.core.router.util.PreProcessEuclidean;
import org.matsim.core.router.util.TravelDisutility;
import org.matsim.core.router.util.TravelTime;
import org.matsim.core.utils.collections.RouterPriorityQueue;
import org.matsim.core.utils.geometry.CoordUtils;

public class AStarEuclidean
extends Dijkstra {
    private static final Logger log = Logger.getLogger(AStarEuclidean.class);
    protected final double overdoFactor;
    private double minTravelCostPerLength;

    AStarEuclidean(Network network, PreProcessEuclidean preProcessData, TravelTime timeFunction) {
        this(network, preProcessData, timeFunction, 1.0);
    }

    AStarEuclidean(Network network, PreProcessEuclidean preProcessData, TravelTime timeFunction, double overdoFactor) {
        this(network, preProcessData, preProcessData.getCostFunction(), timeFunction, overdoFactor);
    }

    AStarEuclidean(Network network, PreProcessEuclidean preProcessData, TravelDisutility costFunction, TravelTime timeFunction, double overdoFactor) {
        super(network, costFunction, timeFunction, preProcessData);
        this.setMinTravelCostPerLength(preProcessData.getMinTravelCostPerLength());
        this.overdoFactor = overdoFactor;
    }

    @Override
    protected void initFromNode(Node fromNode, Node toNode, double startTime, RouterPriorityQueue<Node> pendingNodes) {
        AStarNodeData data = this.getData(fromNode);
        this.visitNode(fromNode, data, pendingNodes, startTime, 0.0, null);
        data.setExpectedRemainingCost(this.estimateRemainingTravelCost(fromNode, toNode));
    }

    @Override
    protected boolean addToPendingNodes(Link l, Node n, RouterPriorityQueue<Node> pendingNodes, double currTime, double currCost, Node toNode) {
        double travelTime = this.timeFunction.getLinkTravelTime(l, currTime, this.person, this.vehicle);
        double travelCost = this.costFunction.getLinkTravelDisutility(l, currTime, this.person, this.vehicle);
        AStarNodeData data = this.getData(n);
        if (!data.isVisited(this.getIterationId())) {
            double remainingTravelCost = this.estimateRemainingTravelCost(n, toNode);
            this.visitNode(n, data, pendingNodes, currTime + travelTime, currCost + travelCost, remainingTravelCost, l);
            return true;
        }
        double totalCost = currCost + travelCost;
        double nCost = data.getCost();
        if (totalCost < nCost) {
            this.revisitNode(n, data, pendingNodes, currTime + travelTime, totalCost, l);
            return true;
        }
        if (totalCost == nCost) {
            if (totalCost == 0.0) {
                log.warn("finding totalCost=" + totalCost + "; this will often (or always?) lead to a null " + "pointer exception later.  In my own case, it was related to a network " + "having freespeed infinity at places.  kai, jan'18");
            }
            if (data.getPrevLink().getId().compareTo(l.getId()) > 0) {
                this.revisitNode(n, data, pendingNodes, currTime + travelTime, totalCost, l);
                return true;
            }
        }
        return false;
    }

    private void visitNode(Node n, AStarNodeData data, RouterPriorityQueue<Node> pendingNodes, double time, double cost, double expectedRemainingCost, Link outLink) {
        data.setExpectedRemainingCost(expectedRemainingCost);
        super.visitNode(n, data, pendingNodes, time, cost, outLink);
    }

    public double getOverdoFactor() {
        return this.overdoFactor;
    }

    protected double estimateRemainingTravelCost(Node fromNode, Node toNode) {
        double dist = CoordUtils.calcEuclideanDistance(fromNode.getCoord(), toNode.getCoord()) * this.getMinTravelCostPerLength();
        return dist * this.overdoFactor;
    }

    @Override
    protected AStarNodeData getData(Node n) {
        return (AStarNodeData)super.getData(n);
    }

    @Override
    protected AStarNodeData createNodeData() {
        return new AStarNodeData();
    }

    void setMinTravelCostPerLength(double minTravelCostPerLength) {
        this.minTravelCostPerLength = minTravelCostPerLength;
    }

    public final double getMinTravelCostPerLength() {
        return this.minTravelCostPerLength;
    }

    @Override
    protected double getPriority(DijkstraNodeData data) {
        return ((AStarNodeData)data).getExpectedCost();
    }
}

