/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.router;

import java.util.HashMap;
import java.util.Map;
import org.matsim.api.core.v01.network.Network;
import org.matsim.core.router.AStarEuclidean;
import org.matsim.core.router.util.LeastCostPathCalculator;
import org.matsim.core.router.util.LeastCostPathCalculatorFactory;
import org.matsim.core.router.util.PreProcessEuclidean;
import org.matsim.core.router.util.TravelDisutility;
import org.matsim.core.router.util.TravelTime;

public class AStarEuclideanFactory
implements LeastCostPathCalculatorFactory {
    private final Map<Network, PreProcessEuclidean> preProcessData = new HashMap<Network, PreProcessEuclidean>();
    private final double overdoFactor;

    public AStarEuclideanFactory() {
        this(1.0);
    }

    public AStarEuclideanFactory(double overdoFactor) {
        this.overdoFactor = overdoFactor;
    }

    @Override
    public synchronized LeastCostPathCalculator createPathCalculator(Network network, TravelDisutility travelCosts, TravelTime travelTimes) {
        PreProcessEuclidean preProcessEuclidean = this.preProcessData.get(network);
        if (preProcessEuclidean == null) {
            preProcessEuclidean = new PreProcessEuclidean(travelCosts);
            preProcessEuclidean.run(network);
            this.preProcessData.put(network, preProcessEuclidean);
        }
        return new AStarEuclidean(network, preProcessEuclidean, travelCosts, travelTimes, this.overdoFactor);
    }
}

