/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.router;

import java.util.ArrayList;
import java.util.Iterator;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.Node;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.router.AStarEuclidean;
import org.matsim.core.router.util.AStarNodeData;
import org.matsim.core.router.util.LeastCostPathCalculator;
import org.matsim.core.router.util.PreProcessLandmarks;
import org.matsim.core.router.util.TravelDisutility;
import org.matsim.core.router.util.TravelTime;
import org.matsim.core.utils.collections.RouterPriorityQueue;
import org.matsim.vehicles.Vehicle;

public class AStarLandmarks
extends AStarEuclidean {
    protected int[] activeLandmarkIndexes;
    protected final Node[] landmarks;
    static final int controlInterval = 40;
    int controlCounter = 0;

    AStarLandmarks(Network network, PreProcessLandmarks preProcessData, TravelDisutility costFunction, TravelTime timeFunction) {
        this(network, preProcessData, costFunction, timeFunction, 1.0);
    }

    AStarLandmarks(Network network, PreProcessLandmarks preProcessData, TravelTime timeFunction) {
        this(network, preProcessData, preProcessData.getCostFunction(), timeFunction, 1.0);
    }

    AStarLandmarks(Network network, PreProcessLandmarks preProcessData, TravelDisutility costFunction, TravelTime timeFunction, double overdoFactor) {
        super(network, preProcessData, costFunction, timeFunction, overdoFactor);
        this.landmarks = preProcessData.getLandmarks();
    }

    @Override
    public LeastCostPathCalculator.Path calcLeastCostPath(Node fromNode, Node toNode, double startTime, Person person, Vehicle vehicle) {
        this.controlCounter = 0;
        if (this.landmarks.length >= 2) {
            this.initializeActiveLandmarks(fromNode, toNode, 2);
        } else {
            this.initializeActiveLandmarks(fromNode, toNode, this.landmarks.length);
        }
        return super.calcLeastCostPath(fromNode, toNode, startTime, person, vehicle);
    }

    @Override
    protected void relaxNode(Node outNode, Node toNode, RouterPriorityQueue<Node> pendingNodes) {
        ++this.controlCounter;
        if (this.controlCounter == 40) {
            int newLandmarkIndex = this.checkToAddLandmark(outNode, toNode);
            if (newLandmarkIndex > 0) {
                this.updatePendingNodes(newLandmarkIndex, toNode, pendingNodes);
            }
            this.controlCounter = 0;
        }
        super.relaxNode(outNode, toNode, pendingNodes);
    }

    void initializeActiveLandmarks(Node fromNode, Node toNode, int actLandmarkCount) {
        PreProcessLandmarks.LandmarksData fromData = this.getPreProcessData(fromNode);
        PreProcessLandmarks.LandmarksData toData = this.getPreProcessData(toNode);
        double[] estTravelTimes = new double[actLandmarkCount];
        this.activeLandmarkIndexes = new int[actLandmarkCount];
        for (int i = 0; i < estTravelTimes.length; ++i) {
            estTravelTimes[i] = Double.NEGATIVE_INFINITY;
        }
        block1: for (int i = 0; i < this.landmarks.length; ++i) {
            double tmpTravTime = this.estimateRemainingTravelCost(fromData, toData, i);
            for (int j = 0; j < estTravelTimes.length; ++j) {
                if (!(tmpTravTime > estTravelTimes[j])) continue;
                for (int k = estTravelTimes.length - 1; k > j; --k) {
                    estTravelTimes[k] = estTravelTimes[k - 1];
                    this.activeLandmarkIndexes[k] = this.activeLandmarkIndexes[k - 1];
                }
                estTravelTimes[j] = tmpTravTime;
                this.activeLandmarkIndexes[j] = i;
                continue block1;
            }
        }
    }

    @Override
    protected PreProcessLandmarks.LandmarksData getPreProcessData(Node n) {
        return (PreProcessLandmarks.LandmarksData)super.getPreProcessData(n);
    }

    @Override
    protected double estimateRemainingTravelCost(Node fromNode, Node toNode) {
        double tmpTravCost;
        PreProcessLandmarks.LandmarksData fromRole = this.getPreProcessData(fromNode);
        PreProcessLandmarks.LandmarksData toRole = this.getPreProcessData(toNode);
        double travCost = 0.0;
        int n = this.activeLandmarkIndexes.length;
        for (int i = 0; i < n; ++i) {
            tmpTravCost = this.estimateRemainingTravelCost(fromRole, toRole, this.activeLandmarkIndexes[i]);
            if (!(tmpTravCost > travCost)) continue;
            travCost = tmpTravCost;
        }
        tmpTravCost = super.estimateRemainingTravelCost(fromNode, toNode);
        if (travCost > tmpTravCost) {
            return travCost;
        }
        return tmpTravCost;
    }

    void updatePendingNodes(int newLandmarkIndex, Node toNode, RouterPriorityQueue<Node> pendingNodes) {
        Iterator<Node> it = pendingNodes.iterator();
        PreProcessLandmarks.LandmarksData toRole = this.getPreProcessData(toNode);
        ArrayList<Double> newEstRemTravCosts = new ArrayList<Double>();
        ArrayList<Object> nodesToBeUpdated = new ArrayList<Object>();
        while (it.hasNext()) {
            Node node = it.next();
            AStarNodeData aStarNodeData = this.getData(node);
            PreProcessLandmarks.LandmarksData ppRole = this.getPreProcessData(node);
            double estRemTravCost = aStarNodeData.getExpectedRemainingCost();
            double newEstRemTravCost = this.estimateRemainingTravelCost(ppRole, toRole, newLandmarkIndex);
            if (!(newEstRemTravCost > estRemTravCost)) continue;
            nodesToBeUpdated.add(node);
            newEstRemTravCosts.add(newEstRemTravCost);
        }
        for (Node node : nodesToBeUpdated) {
            pendingNodes.remove(node);
        }
        for (int i = 0; i < nodesToBeUpdated.size(); ++i) {
            Node node = (Node)nodesToBeUpdated.get(i);
            AStarNodeData data = this.getData(node);
            data.setExpectedRemainingCost((Double)newEstRemTravCosts.get(i));
            pendingNodes.add(node, this.getPriority(data));
        }
    }

    int checkToAddLandmark(Node fromNode, Node toNode) {
        double bestTravCostEst = this.estimateRemainingTravelCost(fromNode, toNode);
        PreProcessLandmarks.LandmarksData fromRole = this.getPreProcessData(fromNode);
        PreProcessLandmarks.LandmarksData toRole = this.getPreProcessData(toNode);
        int bestIndex = -1;
        for (int i = 0; i < this.landmarks.length; ++i) {
            double tmpTravTime = this.estimateRemainingTravelCost(fromRole, toRole, i);
            if (!(tmpTravTime > bestTravCostEst)) continue;
            bestIndex = i;
            bestTravCostEst = tmpTravTime;
        }
        if (bestIndex != -1) {
            int[] newActiveLandmarks = new int[this.activeLandmarkIndexes.length + 1];
            System.arraycopy(this.activeLandmarkIndexes, 0, newActiveLandmarks, 0, this.activeLandmarkIndexes.length);
            newActiveLandmarks[this.activeLandmarkIndexes.length] = bestIndex;
            this.activeLandmarkIndexes = newActiveLandmarks;
        }
        return bestIndex;
    }

    protected double estimateRemainingTravelCost(PreProcessLandmarks.LandmarksData fromRole, PreProcessLandmarks.LandmarksData toRole, int index) {
        double toMaxLandmarkTravelTime;
        double fromMinLandmarkTravelTime = fromRole.getMinLandmarkTravelTime(index);
        double tmpTravTime = fromMinLandmarkTravelTime - (toMaxLandmarkTravelTime = toRole.getMaxLandmarkTravelTime(index));
        if (tmpTravTime < 0.0 && (tmpTravTime = toRole.getMinLandmarkTravelTime(index) - fromRole.getMaxLandmarkTravelTime(index)) <= 0.0) {
            return 0.0;
        }
        return tmpTravTime * this.overdoFactor;
    }
}

