/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.router;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.matsim.api.core.v01.network.Network;
import org.matsim.core.config.groups.GlobalConfigGroup;
import org.matsim.core.router.AStarLandmarks;
import org.matsim.core.router.util.LeastCostPathCalculator;
import org.matsim.core.router.util.LeastCostPathCalculatorFactory;
import org.matsim.core.router.util.PreProcessLandmarks;
import org.matsim.core.router.util.TravelDisutility;
import org.matsim.core.router.util.TravelTime;

@Singleton
public class AStarLandmarksFactory
implements LeastCostPathCalculatorFactory {
    private final Map<Network, PreProcessLandmarks> preProcessData = new HashMap<Network, PreProcessLandmarks>();
    private final int nThreads;

    @Inject
    public AStarLandmarksFactory(GlobalConfigGroup globalConfigGroup) {
        this(globalConfigGroup.getNumberOfThreads());
    }

    public AStarLandmarksFactory(int numberOfThreads) {
        this.nThreads = numberOfThreads;
    }

    public AStarLandmarksFactory() {
        this(8);
    }

    @Override
    public synchronized LeastCostPathCalculator createPathCalculator(Network network, TravelDisutility travelCosts, TravelTime travelTimes) {
        PreProcessLandmarks preProcessLandmarks = this.preProcessData.get(network);
        if (preProcessLandmarks == null) {
            preProcessLandmarks = new PreProcessLandmarks(travelCosts);
            preProcessLandmarks.setNumberOfThreads(this.nThreads);
            preProcessLandmarks.run(network);
            this.preProcessData.put(network, preProcessLandmarks);
        }
        double overdoFactor = 1.0;
        return new AStarLandmarks(network, preProcessLandmarks, travelCosts, travelTimes, 1.0);
    }
}

