/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.router;

import java.util.ArrayList;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Node;
import org.matsim.core.router.Dijkstra;
import org.matsim.core.router.FastRouterDelegate;
import org.matsim.core.router.util.LeastCostPathCalculator;
import org.matsim.core.router.util.NodeData;
import org.matsim.core.router.util.NodeDataFactory;
import org.matsim.core.router.util.PreProcessDijkstra;
import org.matsim.core.router.util.RoutingNetworkLink;
import org.matsim.core.router.util.RoutingNetworkNode;
import org.matsim.core.utils.collections.RouterPriorityQueue;

abstract class AbstractFastRouterDelegate
implements FastRouterDelegate {
    final Dijkstra dijkstra;
    final NodeDataFactory nodeDataFactory;

    AbstractFastRouterDelegate(Dijkstra dijkstra, NodeDataFactory nodeDataFactory) {
        this.dijkstra = dijkstra;
        this.nodeDataFactory = nodeDataFactory;
    }

    @Override
    public void initialize() {
    }

    @Override
    public LeastCostPathCalculator.Path constructPath(Node fromNode, Node toNode, double startTime, double arrivalTime) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        ArrayList<Link> links = new ArrayList<Link>();
        nodes.add(0, ((RoutingNetworkNode)toNode).getNode());
        Link tmpLink = this.getData(toNode).getPrevLink();
        while (tmpLink != null) {
            links.add(0, ((RoutingNetworkLink)tmpLink).getLink());
            nodes.add(0, ((RoutingNetworkLink)tmpLink).getLink().getFromNode());
            tmpLink = this.getData(tmpLink.getFromNode()).getPrevLink();
        }
        NodeData toNodeData = this.getData(toNode);
        return new LeastCostPathCalculator.Path(nodes, links, arrivalTime - startTime, toNodeData.getCost());
    }

    @Override
    public void relaxNode(Node outNode, Node toNode, RouterPriorityQueue<Node> pendingNodes) {
        RoutingNetworkNode routingNetworkNode = (RoutingNetworkNode)outNode;
        NodeData outData = this.getData(routingNetworkNode);
        double currTime = outData.getTime();
        double currCost = outData.getCost();
        if (this.dijkstra.pruneDeadEnds) {
            PreProcessDijkstra.DeadEndData ddOutData = this.getPreProcessData(routingNetworkNode);
            for (RoutingNetworkLink l : routingNetworkNode.getOutLinksArray()) {
                this.dijkstra.relaxNodeLogic(l, pendingNodes, currTime, currCost, toNode, ddOutData);
            }
        } else {
            for (RoutingNetworkLink l : routingNetworkNode.getOutLinksArray()) {
                this.dijkstra.relaxNodeLogic(l, pendingNodes, currTime, currCost, toNode, null);
            }
        }
    }

    @Override
    public PreProcessDijkstra.DeadEndData getPreProcessData(Node n) {
        return ((RoutingNetworkNode)n).getDeadEndData();
    }
}

