/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.router;

import org.matsim.api.core.v01.network.Node;
import org.matsim.core.router.AbstractFastRouterDelegate;
import org.matsim.core.router.Dijkstra;
import org.matsim.core.router.util.ArrayRoutingNetwork;
import org.matsim.core.router.util.ArrayRoutingNetworkNode;
import org.matsim.core.router.util.NodeData;
import org.matsim.core.router.util.NodeDataFactory;

class ArrayFastRouterDelegate
extends AbstractFastRouterDelegate {
    private final ArrayRoutingNetwork network;
    private final NodeData[] nodeData;
    private boolean isInitialized = false;

    ArrayFastRouterDelegate(Dijkstra dijkstra, NodeDataFactory nodeDataFactory, ArrayRoutingNetwork network) {
        super(dijkstra, nodeDataFactory);
        this.network = network;
        this.nodeData = new NodeData[network.getNodes().size()];
    }

    @Override
    public final void initialize() {
        if (!this.isInitialized) {
            for (Node node : this.network.getNodes().values()) {
                int index = ((ArrayRoutingNetworkNode)node).getArrayIndex();
                this.nodeData[index] = this.nodeDataFactory.createNodeData();
            }
            this.isInitialized = true;
        }
    }

    @Override
    public NodeData getData(Node n) {
        ArrayRoutingNetworkNode routingNetworkNode = (ArrayRoutingNetworkNode)n;
        return this.nodeData[routingNetworkNode.getArrayIndex()];
    }
}

