/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.router;

import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.population.PopulationFactory;
import org.matsim.core.config.groups.PlansCalcRouteConfigGroup;
import org.matsim.core.router.FreespeedFactorRoutingModule;
import org.matsim.core.router.NetworkRoutingInclAccessEgressModule;
import org.matsim.core.router.NetworkRoutingModule;
import org.matsim.core.router.RoutingModule;
import org.matsim.core.router.TeleportationRoutingModule;
import org.matsim.core.router.util.LeastCostPathCalculator;

public final class DefaultRoutingModules {
    private DefaultRoutingModules() {
    }

    public static RoutingModule createPseudoTransitRouter(String mode, PopulationFactory popFac, Network net, LeastCostPathCalculator routeAlgo, PlansCalcRouteConfigGroup.ModeRoutingParams params) {
        return new FreespeedFactorRoutingModule(mode, popFac, net, routeAlgo, params);
    }

    public static RoutingModule createTeleportationRouter(String mode, Scenario scenario, PlansCalcRouteConfigGroup.ModeRoutingParams params) {
        return new TeleportationRoutingModule(mode, scenario, params.getTeleportedModeSpeed(), params.getBeelineDistanceFactor());
    }

    public static RoutingModule createPureNetworkRouter(String mode, PopulationFactory popFact, Network net, LeastCostPathCalculator routeAlgo) {
        return new NetworkRoutingModule(mode, popFact, net, routeAlgo);
    }

    public static RoutingModule createAccessEgressNetworkRouter(String mode, LeastCostPathCalculator routeAlgo, Scenario scenario, Network filteredNetwork) {
        return new NetworkRoutingInclAccessEgressModule(mode, routeAlgo, scenario, filteredNetwork);
    }
}

