/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.router;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.Node;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.router.priorityqueue.WrappedBinaryMinHeap;
import org.matsim.core.router.util.DijkstraNodeData;
import org.matsim.core.router.util.LeastCostPathCalculator;
import org.matsim.core.router.util.PreProcessDijkstra;
import org.matsim.core.router.util.TravelDisutility;
import org.matsim.core.router.util.TravelTime;
import org.matsim.core.utils.collections.RouterPriorityQueue;
import org.matsim.vehicles.Vehicle;

public class Dijkstra
implements LeastCostPathCalculator {
    private static final Logger log = Logger.getLogger(Dijkstra.class);
    protected Network network;
    protected final TravelDisutility costFunction;
    protected final TravelTime timeFunction;
    final HashMap<Id<Node>, DijkstraNodeData> nodeData;
    private int iterationID = -2147483647;
    private Node deadEndEntryNode;
    final boolean pruneDeadEnds;
    private final PreProcessDijkstra preProcessData;
    private RouterPriorityQueue<Node> heap = null;
    private String[] modeRestriction = null;
    Person person = null;
    Vehicle vehicle = null;

    protected Dijkstra(Network network, TravelDisutility costFunction, TravelTime timeFunction) {
        this(network, costFunction, timeFunction, null);
    }

    protected Dijkstra(Network network, TravelDisutility costFunction, TravelTime timeFunction, PreProcessDijkstra preProcessData) {
        this.network = network;
        this.costFunction = costFunction;
        this.timeFunction = timeFunction;
        this.preProcessData = preProcessData;
        this.nodeData = new HashMap((int)((double)network.getNodes().size() * 1.1), 0.95f);
        if (preProcessData != null) {
            if (!preProcessData.containsData()) {
                this.pruneDeadEnds = false;
                log.warn("The preprocessing data provided to router class Dijkstra contains no data! Please execute its run(...) method first!");
                log.warn("Running without dead-end pruning.");
            } else {
                this.pruneDeadEnds = true;
            }
        } else {
            this.pruneDeadEnds = false;
        }
    }

    @Deprecated
    public void setModeRestriction(Set<String> modeRestriction) {
        this.modeRestriction = modeRestriction == null ? null : modeRestriction.toArray(new String[modeRestriction.size()]);
    }

    @Override
    public LeastCostPathCalculator.Path calcLeastCostPath(Node fromNode, Node toNode, double startTime, Person person2, Vehicle vehicle2) {
        this.checkNodeBelongToNetwork(fromNode);
        this.checkNodeBelongToNetwork(toNode);
        this.augmentIterationId();
        this.person = person2;
        this.vehicle = vehicle2;
        if (this.pruneDeadEnds) {
            this.deadEndEntryNode = this.getPreProcessData(toNode).getDeadEndEntryNode();
        }
        RouterPriorityQueue<Node> pendingNodes = this.createRouterPriorityQueue();
        this.initFromNode(fromNode, toNode, startTime, pendingNodes);
        Node foundToNode = this.searchLogic(fromNode, toNode, pendingNodes);
        if (foundToNode == null) {
            return null;
        }
        DijkstraNodeData outData = this.getData(foundToNode);
        double arrivalTime = outData.getTime();
        return this.constructPath(fromNode, foundToNode, startTime, arrivalTime);
    }

    void checkNodeBelongToNetwork(Node node) {
        if (this.network.getNodes().get(node.getId()) != node) {
            throw new IllegalArgumentException("The nodes passed as parameters are not part of the network stored by " + this.getClass().getSimpleName() + ": the validity of the results cannot be guaranteed. Aborting!");
        }
    }

    RouterPriorityQueue<? extends Node> createRouterPriorityQueue() {
        if (this.heap == null) {
            this.heap = new WrappedBinaryMinHeap<Node>(this.network.getNodes().size());
            for (Node node : this.network.getNodes().values()) {
                this.heap.add(node, 0.0);
            }
        }
        this.heap.reset();
        return this.heap;
    }

    Node searchLogic(Node fromNode, Node toNode, RouterPriorityQueue<Node> pendingNodes) {
        boolean stillSearching = true;
        while (stillSearching) {
            Node outNode = pendingNodes.poll();
            if (outNode == null) {
                log.warn("No route was found from node " + fromNode.getId() + " to node " + toNode.getId() + ". Some possible reasons:");
                log.warn("  * Network is not connected.  Run NetworkCleaner().");
                log.warn("  * Network for considered mode does not even exist.  Modes need to be entered for each link in network.xml.");
                log.warn("  * Network for considered mode is not connected to starting or ending point of route.  Setting insertingAccessEgressWalk to true may help.");
                log.warn("This will now return null, but it may fail later with a null pointer exception.");
                return null;
            }
            if (outNode == toNode) {
                stillSearching = false;
                continue;
            }
            this.relaxNode(outNode, toNode, pendingNodes);
        }
        return toNode;
    }

    protected LeastCostPathCalculator.Path constructPath(Node fromNode, Node toNode, double startTime, double arrivalTime) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        ArrayList<Link> links = new ArrayList<Link>();
        nodes.add(0, toNode);
        Link tmpLink = this.getData(toNode).getPrevLink();
        if (tmpLink != null) {
            while (tmpLink.getFromNode() != fromNode) {
                links.add(0, tmpLink);
                nodes.add(0, tmpLink.getFromNode());
                tmpLink = this.getData(tmpLink.getFromNode()).getPrevLink();
            }
            links.add(0, tmpLink);
            nodes.add(0, tmpLink.getFromNode());
        }
        DijkstraNodeData toNodeData = this.getData(toNode);
        LeastCostPathCalculator.Path path = new LeastCostPathCalculator.Path(nodes, links, arrivalTime - startTime, toNodeData.getCost());
        return path;
    }

    void initFromNode(Node fromNode, Node toNode, double startTime, RouterPriorityQueue<Node> pendingNodes) {
        DijkstraNodeData data = this.getData(fromNode);
        this.visitNode(fromNode, data, pendingNodes, startTime, 0.0, null);
    }

    protected void relaxNode(Node outNode, Node toNode, RouterPriorityQueue<Node> pendingNodes) {
        DijkstraNodeData outData = this.getData(outNode);
        double currTime = outData.getTime();
        double currCost = outData.getCost();
        if (this.pruneDeadEnds) {
            PreProcessDijkstra.DeadEndData ddOutData = this.getPreProcessData(outNode);
            for (Link link : outNode.getOutLinks().values()) {
                this.relaxNodeLogic(link, pendingNodes, currTime, currCost, toNode, ddOutData);
            }
        } else {
            for (Link link : outNode.getOutLinks().values()) {
                this.relaxNodeLogic(link, pendingNodes, currTime, currCost, toNode, null);
            }
        }
    }

    void relaxNodeLogic(Link l, RouterPriorityQueue<Node> pendingNodes, double currTime, double currCost, Node toNode, PreProcessDijkstra.DeadEndData ddOutData) {
        if (this.pruneDeadEnds) {
            Node n;
            PreProcessDijkstra.DeadEndData ddData;
            if (this.canPassLink(l) && ((ddData = this.getPreProcessData(n = l.getToNode())).getDeadEndEntryNode() == null || ddOutData.getDeadEndEntryNode() != null || this.deadEndEntryNode != null && this.deadEndEntryNode.getId() == ddData.getDeadEndEntryNode().getId())) {
                this.addToPendingNodes(l, n, pendingNodes, currTime, currCost, toNode);
            }
        } else if (this.canPassLink(l)) {
            this.addToPendingNodes(l, l.getToNode(), pendingNodes, currTime, currCost, toNode);
        }
    }

    protected boolean addToPendingNodes(Link l, Node n, RouterPriorityQueue<Node> pendingNodes, double currTime, double currCost, Node toNode) {
        Link prevLink;
        double travelTime = this.timeFunction.getLinkTravelTime(l, currTime, this.person, this.vehicle);
        double travelCost = this.costFunction.getLinkTravelDisutility(l, currTime, this.person, this.vehicle);
        DijkstraNodeData data = this.getData(n);
        if (!data.isVisited(this.getIterationId())) {
            this.visitNode(n, data, pendingNodes, currTime + travelTime, currCost + travelCost, l);
            return true;
        }
        double totalCost = currCost + travelCost;
        double nCost = data.getCost();
        if (totalCost < nCost) {
            this.revisitNode(n, data, pendingNodes, currTime + travelTime, totalCost, l);
            return true;
        }
        if (totalCost == nCost && (prevLink = data.getPrevLink()) != null && prevLink.getId().compareTo(l.getId()) > 0) {
            this.revisitNode(n, data, pendingNodes, currTime + travelTime, totalCost, l);
            return true;
        }
        return false;
    }

    protected boolean canPassLink(Link link) {
        if (this.modeRestriction == null) {
            return true;
        }
        for (String mode : this.modeRestriction) {
            if (!link.getAllowedModes().contains(mode)) continue;
            return true;
        }
        return false;
    }

    protected void revisitNode(Node n, DijkstraNodeData data, RouterPriorityQueue<Node> pendingNodes, double time, double cost, Link outLink) {
        data.visit(outLink, cost, time, this.getIterationId());
        pendingNodes.decreaseKey(n, this.getPriority(data));
    }

    protected void visitNode(Node n, DijkstraNodeData data, RouterPriorityQueue<Node> pendingNodes, double time, double cost, Link outLink) {
        data.visit(outLink, cost, time, this.getIterationId());
        pendingNodes.add(n, this.getPriority(data));
    }

    protected void augmentIterationId() {
        if (this.getIterationId() == Integer.MAX_VALUE) {
            this.iterationID = -2147483647;
            this.resetNetworkVisited();
        } else {
            ++this.iterationID;
        }
    }

    protected int getIterationId() {
        return this.iterationID;
    }

    private void resetNetworkVisited() {
        for (Node node : this.network.getNodes().values()) {
            DijkstraNodeData data = this.getData(node);
            data.resetVisited();
        }
    }

    protected double getPriority(DijkstraNodeData data) {
        return data.getCost();
    }

    protected DijkstraNodeData getData(Node n) {
        DijkstraNodeData r = this.nodeData.get(n.getId());
        if (null == r) {
            r = this.createNodeData();
            this.nodeData.put(n.getId(), r);
        }
        return r;
    }

    protected DijkstraNodeData createNodeData() {
        return new DijkstraNodeData();
    }

    protected PreProcessDijkstra.DeadEndData getPreProcessData(Node n) {
        return this.preProcessData.getNodeData(n);
    }

    protected final Person getPerson() {
        return this.person;
    }

    protected final Vehicle getVehicle() {
        return this.vehicle;
    }
}

