/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.router;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.matsim.api.core.v01.network.Network;
import org.matsim.core.router.Dijkstra;
import org.matsim.core.router.util.LeastCostPathCalculator;
import org.matsim.core.router.util.LeastCostPathCalculatorFactory;
import org.matsim.core.router.util.PreProcessDijkstra;
import org.matsim.core.router.util.TravelDisutility;
import org.matsim.core.router.util.TravelTime;

@Singleton
public class DijkstraFactory
implements LeastCostPathCalculatorFactory {
    private final boolean usePreProcessData;
    private final Map<Network, PreProcessDijkstra> preProcessData = new HashMap<Network, PreProcessDijkstra>();

    @Inject
    public DijkstraFactory() {
        this.usePreProcessData = false;
    }

    public DijkstraFactory(boolean usePreProcessData) {
        this.usePreProcessData = usePreProcessData;
    }

    @Override
    public synchronized LeastCostPathCalculator createPathCalculator(Network network, TravelDisutility travelCosts, TravelTime travelTimes) {
        if (this.usePreProcessData) {
            PreProcessDijkstra preProcessDijkstra = this.preProcessData.get(network);
            if (preProcessDijkstra == null) {
                preProcessDijkstra = new PreProcessDijkstra();
                preProcessDijkstra.run(network);
                this.preProcessData.put(network, preProcessDijkstra);
            }
            return new Dijkstra(network, travelCosts, travelTimes, preProcessDijkstra);
        }
        return new Dijkstra(network, travelCosts, travelTimes);
    }
}

