/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.router;

import org.matsim.api.core.v01.network.Node;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.router.AStarEuclidean;
import org.matsim.core.router.FastRouterDelegate;
import org.matsim.core.router.FastRouterDelegateFactory;
import org.matsim.core.router.priorityqueue.BinaryMinHeap;
import org.matsim.core.router.util.AStarNodeData;
import org.matsim.core.router.util.AStarNodeDataFactory;
import org.matsim.core.router.util.ArrayRoutingNetwork;
import org.matsim.core.router.util.ArrayRoutingNetworkNode;
import org.matsim.core.router.util.LeastCostPathCalculator;
import org.matsim.core.router.util.PreProcessDijkstra;
import org.matsim.core.router.util.PreProcessEuclidean;
import org.matsim.core.router.util.RoutingNetwork;
import org.matsim.core.router.util.RoutingNetworkNode;
import org.matsim.core.router.util.TravelDisutility;
import org.matsim.core.router.util.TravelTime;
import org.matsim.core.utils.collections.RouterPriorityQueue;
import org.matsim.vehicles.Vehicle;

public class FastAStarEuclidean
extends AStarEuclidean {
    private final RoutingNetwork routingNetwork;
    private final FastRouterDelegate fastRouter;
    private BinaryMinHeap<ArrayRoutingNetworkNode> heap = null;
    private int maxSize = -1;

    FastAStarEuclidean(RoutingNetwork routingNetwork, PreProcessEuclidean preProcessData, TravelDisutility costFunction, TravelTime timeFunction, double overdoFactor, FastRouterDelegateFactory fastRouterFactory) {
        super(routingNetwork, preProcessData, costFunction, timeFunction, overdoFactor);
        this.routingNetwork = routingNetwork;
        this.fastRouter = fastRouterFactory.createFastRouterDelegate(this, new AStarNodeDataFactory(), routingNetwork);
        this.nodeData.clear();
    }

    @Override
    public LeastCostPathCalculator.Path calcLeastCostPath(Node fromNode, Node toNode, double startTime, Person person, Vehicle vehicle) {
        this.fastRouter.initialize();
        this.routingNetwork.initialize();
        RoutingNetworkNode routingNetworkFromNode = this.routingNetwork.getNodes().get(fromNode.getId());
        RoutingNetworkNode routingNetworkToNode = this.routingNetwork.getNodes().get(toNode.getId());
        return super.calcLeastCostPath(routingNetworkFromNode, routingNetworkToNode, startTime, person, vehicle);
    }

    @Override
    RouterPriorityQueue<? extends Node> createRouterPriorityQueue() {
        if (this.routingNetwork instanceof ArrayRoutingNetwork) {
            int size = this.routingNetwork.getNodes().size();
            if (this.heap == null || this.maxSize != size) {
                this.maxSize = size;
                this.heap = new BinaryMinHeap(this.maxSize);
                return this.heap;
            }
            this.heap.reset();
            return this.heap;
        }
        return super.createRouterPriorityQueue();
    }

    @Override
    protected LeastCostPathCalculator.Path constructPath(Node fromNode, Node toNode, double startTime, double arrivalTime) {
        return this.fastRouter.constructPath(fromNode, toNode, startTime, arrivalTime);
    }

    @Override
    protected void relaxNode(Node outNode, Node toNode, RouterPriorityQueue<Node> pendingNodes) {
        this.fastRouter.relaxNode(outNode, toNode, pendingNodes);
    }

    @Override
    protected AStarNodeData getData(Node n) {
        return (AStarNodeData)this.fastRouter.getData(n);
    }

    @Override
    protected PreProcessDijkstra.DeadEndData getPreProcessData(Node n) {
        return this.fastRouter.getPreProcessData(n);
    }
}

