/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.router;

import java.util.HashMap;
import java.util.Map;
import org.matsim.api.core.v01.network.Network;
import org.matsim.core.router.ArrayFastRouterDelegateFactory;
import org.matsim.core.router.FastAStarEuclidean;
import org.matsim.core.router.FastRouterType;
import org.matsim.core.router.util.ArrayRoutingNetworkFactory;
import org.matsim.core.router.util.LeastCostPathCalculator;
import org.matsim.core.router.util.LeastCostPathCalculatorFactory;
import org.matsim.core.router.util.PreProcessEuclidean;
import org.matsim.core.router.util.RoutingNetwork;
import org.matsim.core.router.util.RoutingNetworkFactory;
import org.matsim.core.router.util.RoutingNetworkNode;
import org.matsim.core.router.util.TravelDisutility;
import org.matsim.core.router.util.TravelTime;

public class FastAStarEuclideanFactory
implements LeastCostPathCalculatorFactory {
    private final RoutingNetworkFactory routingNetworkFactory;
    private final Map<Network, RoutingNetwork> routingNetworks = new HashMap<Network, RoutingNetwork>();
    private final Map<Network, PreProcessEuclidean> preProcessData = new HashMap<Network, PreProcessEuclidean>();
    private final double overdoFactor;

    public FastAStarEuclideanFactory() {
        this(1.0);
    }

    public FastAStarEuclideanFactory(double overdoFactor) {
        this(FastRouterType.ARRAY, overdoFactor);
    }

    private FastAStarEuclideanFactory(FastRouterType fastRouterType, double overdoFactor) {
        this.overdoFactor = overdoFactor;
        switch (fastRouterType) {
            case ARRAY: {
                this.routingNetworkFactory = new ArrayRoutingNetworkFactory();
                break;
            }
            case POINTER: {
                throw new RuntimeException("PointerRoutingNetworks are no longer supported. Use ArrayRoutingNetworks instead. Aborting!");
            }
            default: {
                throw new RuntimeException("Undefined FastRouterType: " + (Object)((Object)fastRouterType));
            }
        }
    }

    @Override
    public synchronized LeastCostPathCalculator createPathCalculator(Network network, TravelDisutility travelCosts, TravelTime travelTimes) {
        RoutingNetwork routingNetwork = this.routingNetworks.get(network);
        PreProcessEuclidean preProcessEuclidean = this.preProcessData.get(network);
        if (routingNetwork == null) {
            routingNetwork = this.routingNetworkFactory.createRoutingNetwork(network);
            if (preProcessEuclidean == null) {
                preProcessEuclidean = new PreProcessEuclidean(travelCosts);
                preProcessEuclidean.run(network);
                this.preProcessData.put(network, preProcessEuclidean);
                for (RoutingNetworkNode node : routingNetwork.getNodes().values()) {
                    node.setDeadEndData(preProcessEuclidean.getNodeData(node.getNode()));
                }
            }
            this.routingNetworks.put(network, routingNetwork);
        }
        ArrayFastRouterDelegateFactory fastRouterFactory = new ArrayFastRouterDelegateFactory();
        return new FastAStarEuclidean(routingNetwork, preProcessEuclidean, travelCosts, travelTimes, this.overdoFactor, fastRouterFactory);
    }
}

