/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.router;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.matsim.api.core.v01.network.Network;
import org.matsim.core.config.groups.GlobalConfigGroup;
import org.matsim.core.router.ArrayFastRouterDelegateFactory;
import org.matsim.core.router.FastAStarLandmarks;
import org.matsim.core.router.FastRouterType;
import org.matsim.core.router.util.ArrayRoutingNetworkFactory;
import org.matsim.core.router.util.LeastCostPathCalculator;
import org.matsim.core.router.util.LeastCostPathCalculatorFactory;
import org.matsim.core.router.util.PreProcessLandmarks;
import org.matsim.core.router.util.RoutingNetwork;
import org.matsim.core.router.util.RoutingNetworkFactory;
import org.matsim.core.router.util.RoutingNetworkNode;
import org.matsim.core.router.util.TravelDisutility;
import org.matsim.core.router.util.TravelTime;

@Singleton
public class FastAStarLandmarksFactory
implements LeastCostPathCalculatorFactory {
    private final RoutingNetworkFactory routingNetworkFactory;
    private final Map<Network, RoutingNetwork> routingNetworks = new HashMap<Network, RoutingNetwork>();
    private final Map<Network, PreProcessLandmarks> preProcessData = new HashMap<Network, PreProcessLandmarks>();
    private final int nThreads;

    @Inject
    public FastAStarLandmarksFactory(GlobalConfigGroup globalConfigGroup) {
        this(FastRouterType.ARRAY, globalConfigGroup.getNumberOfThreads());
    }

    public FastAStarLandmarksFactory() {
        this(8);
    }

    public FastAStarLandmarksFactory(int nThreads) {
        this(FastRouterType.ARRAY, nThreads);
    }

    private FastAStarLandmarksFactory(FastRouterType fastRouterType, int numberOfThreads) {
        switch (fastRouterType) {
            case ARRAY: {
                this.routingNetworkFactory = new ArrayRoutingNetworkFactory();
                break;
            }
            case POINTER: {
                throw new RuntimeException("PointerRoutingNetworks are no longer supported. Use ArrayRoutingNetworks instead. Aborting!");
            }
            default: {
                throw new RuntimeException("Undefined FastRouterType: " + (Object)((Object)fastRouterType));
            }
        }
        this.nThreads = numberOfThreads;
    }

    @Override
    public synchronized LeastCostPathCalculator createPathCalculator(Network network, TravelDisutility travelCosts, TravelTime travelTimes) {
        RoutingNetwork routingNetwork = this.routingNetworks.get(network);
        PreProcessLandmarks preProcessLandmarks = this.preProcessData.get(network);
        if (routingNetwork == null) {
            routingNetwork = this.routingNetworkFactory.createRoutingNetwork(network);
            if (preProcessLandmarks == null) {
                preProcessLandmarks = new PreProcessLandmarks(travelCosts);
                preProcessLandmarks.setNumberOfThreads(this.nThreads);
                preProcessLandmarks.run(network);
                this.preProcessData.put(network, preProcessLandmarks);
                for (RoutingNetworkNode node : routingNetwork.getNodes().values()) {
                    node.setDeadEndData(preProcessLandmarks.getNodeData(node.getNode()));
                }
            }
            this.routingNetworks.put(network, routingNetwork);
        }
        ArrayFastRouterDelegateFactory fastRouterFactory = new ArrayFastRouterDelegateFactory();
        double overdoFactor = 1.0;
        return new FastAStarLandmarks(routingNetwork, preProcessLandmarks, travelCosts, travelTimes, 1.0, fastRouterFactory);
    }
}

