/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.router;

import java.util.Collection;
import org.matsim.api.core.v01.network.Node;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.router.FastRouterDelegate;
import org.matsim.core.router.FastRouterDelegateFactory;
import org.matsim.core.router.ImaginaryNode;
import org.matsim.core.router.InitialNode;
import org.matsim.core.router.MultiNodeDijkstra;
import org.matsim.core.router.priorityqueue.BinaryMinHeap;
import org.matsim.core.router.util.ArrayRoutingNetwork;
import org.matsim.core.router.util.ArrayRoutingNetworkNode;
import org.matsim.core.router.util.DijkstraNodeData;
import org.matsim.core.router.util.DijkstraNodeDataFactory;
import org.matsim.core.router.util.LeastCostPathCalculator;
import org.matsim.core.router.util.PreProcessDijkstra;
import org.matsim.core.router.util.RoutingNetwork;
import org.matsim.core.router.util.RoutingNetworkNode;
import org.matsim.core.router.util.TravelDisutility;
import org.matsim.core.router.util.TravelTime;
import org.matsim.core.utils.collections.RouterPriorityQueue;
import org.matsim.vehicles.Vehicle;

public class FastMultiNodeDijkstra
extends MultiNodeDijkstra {
    final RoutingNetwork routingNetwork;
    private final FastRouterDelegate fastRouter;
    private BinaryMinHeap<ArrayRoutingNetworkNode> heap = null;
    private int maxSize = -1;

    protected FastMultiNodeDijkstra(RoutingNetwork routingNetwork, TravelDisutility costFunction, TravelTime timeFunction, PreProcessDijkstra preProcessData, FastRouterDelegateFactory fastRouterFactory, boolean searchAllEndNodes) {
        super(routingNetwork, costFunction, timeFunction, preProcessData, searchAllEndNodes);
        this.routingNetwork = routingNetwork;
        this.fastRouter = fastRouterFactory.createFastRouterDelegate(this, new DijkstraNodeDataFactory(), routingNetwork);
        this.nodeData.clear();
    }

    @Override
    public LeastCostPathCalculator.Path calcLeastCostPath(Node fromNode, Node toNode, double startTime, Person person, Vehicle vehicle) {
        Node routingNetworkToNode;
        Node routingNetworkFromNode;
        Collection<? extends InitialNode> initialNodes;
        this.fastRouter.initialize();
        this.routingNetwork.initialize();
        if (fromNode instanceof ImaginaryNode) {
            initialNodes = ((ImaginaryNode)fromNode).initialNodes;
            for (InitialNode initialNode : initialNodes) {
                initialNode.node = this.routingNetwork.getNodes().get(initialNode.node.getId());
            }
            routingNetworkFromNode = fromNode;
        } else {
            routingNetworkFromNode = this.routingNetwork.getNodes().get(fromNode.getId());
        }
        if (toNode instanceof ImaginaryNode) {
            initialNodes = ((ImaginaryNode)toNode).initialNodes;
            for (InitialNode initialNode : initialNodes) {
                initialNode.node = this.routingNetwork.getNodes().get(initialNode.node.getId());
            }
            routingNetworkToNode = toNode;
        } else {
            routingNetworkToNode = this.routingNetwork.getNodes().get(toNode.getId());
        }
        return super.calcLeastCostPath(routingNetworkFromNode, routingNetworkToNode, startTime, person, vehicle);
    }

    @Override
    RouterPriorityQueue<? extends Node> createRouterPriorityQueue() {
        if (this.routingNetwork instanceof ArrayRoutingNetwork) {
            int size = this.routingNetwork.getNodes().size();
            if (this.heap == null || this.maxSize != size) {
                this.maxSize = size;
                this.heap = new BinaryMinHeap(this.maxSize);
                return this.heap;
            }
            this.heap.reset();
            return this.heap;
        }
        return super.createRouterPriorityQueue();
    }

    @Override
    protected LeastCostPathCalculator.Path constructPath(Node fromNode, Node toNode, double startTime, double arrivalTime) {
        ImaginaryNode imaginaryNode = null;
        if (fromNode instanceof ImaginaryNode) {
            imaginaryNode = (ImaginaryNode)fromNode;
        }
        if (!(fromNode instanceof RoutingNetworkNode)) {
            fromNode = this.routingNetwork.getNodes().get(fromNode.getId());
        }
        if (!(toNode instanceof RoutingNetworkNode)) {
            toNode = this.routingNetwork.getNodes().get(toNode.getId());
        }
        LeastCostPathCalculator.Path path = this.fastRouter.constructPath(fromNode, toNode, startTime, arrivalTime);
        if (imaginaryNode != null && path != null && path.nodes.size() > 0) {
            Node pathFromNode = path.getFromNode();
            double initialCost = 0.0;
            double initialTime = 0.0;
            for (InitialNode initialNode : imaginaryNode.initialNodes) {
                if (!initialNode.node.getId().equals(pathFromNode.getId())) continue;
                initialCost = initialNode.initialCost;
                initialTime = initialNode.initialTime;
                break;
            }
            return new LeastCostPathCalculator.Path(path.nodes, path.links, path.travelTime - initialTime, path.travelCost - initialCost);
        }
        return path;
    }

    @Override
    public LeastCostPathCalculator.Path constructPath(Node fromNode, Node toNode, double startTime) {
        if (toNode == null || fromNode == null) {
            return null;
        }
        if (!(fromNode instanceof RoutingNetworkNode)) {
            fromNode = this.routingNetwork.getNodes().get(fromNode.getId());
        }
        if (!(toNode instanceof RoutingNetworkNode)) {
            toNode = this.routingNetwork.getNodes().get(toNode.getId());
        }
        return super.constructPath(fromNode, toNode, startTime);
    }

    @Override
    protected void relaxNode(Node outNode, Node toNode, RouterPriorityQueue<Node> pendingNodes) {
        this.fastRouter.relaxNode(outNode, toNode, pendingNodes);
    }

    @Override
    protected DijkstraNodeData getData(Node n) {
        return (DijkstraNodeData)this.fastRouter.getData(n);
    }

    @Override
    protected PreProcessDijkstra.DeadEndData getPreProcessData(Node n) {
        return this.fastRouter.getPreProcessData(n);
    }
}

