/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.router;

import javax.inject.Inject;
import javax.inject.Provider;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.PopulationFactory;
import org.matsim.core.config.groups.PlansCalcRouteConfigGroup;
import org.matsim.core.gbl.Gbl;
import org.matsim.core.router.DefaultRoutingModules;
import org.matsim.core.router.RoutingModule;
import org.matsim.core.router.util.LeastCostPathCalculator;
import org.matsim.core.router.util.LeastCostPathCalculatorFactory;
import org.matsim.core.router.util.TravelDisutility;
import org.matsim.core.router.util.TravelTime;
import org.matsim.vehicles.Vehicle;

class FreespeedFactorRouting
implements Provider<RoutingModule> {
    private final PlansCalcRouteConfigGroup.ModeRoutingParams params;
    @Inject
    private Network network;
    @Inject
    private PopulationFactory populationFactory;
    @Inject
    private LeastCostPathCalculatorFactory leastCostPathCalculatorFactory;

    public FreespeedFactorRouting(PlansCalcRouteConfigGroup.ModeRoutingParams params) {
        this.params = params;
    }

    @Override
    public RoutingModule get() {
        final TravelTime travelTime = new TravelTime(){

            @Override
            public double getLinkTravelTime(Link link, double time, Person person, Vehicle vehicle) {
                return link.getLength() / Math.min(link.getFreespeed(time), FreespeedFactorRouting.this.params.getTeleportedModeFreespeedLimit());
            }
        };
        TravelDisutility travelDisutility = new TravelDisutility(){

            @Override
            public double getLinkTravelDisutility(Link link, double time, Person person, Vehicle vehicle) {
                return travelTime.getLinkTravelTime(link, time, person, vehicle);
            }

            @Override
            public double getLinkMinimumTravelDisutility(Link link) {
                return link.getLength() / Math.min(link.getFreespeed(), FreespeedFactorRouting.this.params.getTeleportedModeFreespeedLimit());
            }
        };
        Gbl.assertNotNull(this.leastCostPathCalculatorFactory);
        LeastCostPathCalculator routeAlgoPtFreeFlow = this.leastCostPathCalculatorFactory.createPathCalculator(this.network, travelDisutility, travelTime);
        return DefaultRoutingModules.createPseudoTransitRouter(this.params.getMode(), this.populationFactory, this.network, routeAlgoPtFreeFlow, this.params);
    }
}

