/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.router;

import java.util.Arrays;
import java.util.List;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.Node;
import org.matsim.api.core.v01.population.Activity;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.PlanElement;
import org.matsim.api.core.v01.population.PopulationFactory;
import org.matsim.api.core.v01.population.Route;
import org.matsim.core.config.groups.PlansCalcRouteConfigGroup;
import org.matsim.core.network.NetworkUtils;
import org.matsim.core.router.EmptyStageActivityTypes;
import org.matsim.core.router.FacilityWrapperActivity;
import org.matsim.core.router.RoutingModule;
import org.matsim.core.router.StageActivityTypes;
import org.matsim.core.router.util.LeastCostPathCalculator;
import org.matsim.core.utils.geometry.CoordUtils;
import org.matsim.facilities.Facility;

public final class FreespeedFactorRoutingModule
implements RoutingModule {
    private final String mode;
    private final PopulationFactory populationFactory;
    private final Network network;
    private final LeastCostPathCalculator routeAlgo;
    private final PlansCalcRouteConfigGroup.ModeRoutingParams params;

    FreespeedFactorRoutingModule(String mode, PopulationFactory populationFactory, Network network, LeastCostPathCalculator routeAlgo, PlansCalcRouteConfigGroup.ModeRoutingParams params) {
        this.network = network;
        this.routeAlgo = routeAlgo;
        this.params = params;
        this.mode = mode;
        this.populationFactory = populationFactory;
    }

    @Override
    public List<? extends PlanElement> calcRoute(Facility fromFacility, Facility toFacility, double departureTime, Person person) {
        Leg newLeg = this.populationFactory.createLeg(this.mode);
        newLeg.setDepartureTime(departureTime);
        double travTime = this.routeLeg(person, newLeg, new FacilityWrapperActivity(fromFacility), new FacilityWrapperActivity(toFacility), departureTime);
        newLeg.setTravelTime(travTime);
        return Arrays.asList(newLeg);
    }

    @Override
    public StageActivityTypes getStageActivityTypes() {
        return EmptyStageActivityTypes.INSTANCE;
    }

    public String toString() {
        return "[LegRouterWrapper: mode=" + this.mode + "]";
    }

    final double routeLeg(Person person, Leg leg, Activity fromAct, Activity toAct, double depTime) {
        int travTime = 0;
        Link fromLink = this.network.getLinks().get(fromAct.getLinkId());
        Link toLink = this.network.getLinks().get(toAct.getLinkId());
        if (fromLink == null) {
            throw new RuntimeException("fromLink missing.");
        }
        if (toLink == null) {
            throw new RuntimeException("toLink missing.");
        }
        if (toLink != fromLink) {
            Node endNode;
            Node startNode = fromLink.getToNode();
            LeastCostPathCalculator.Path path = this.routeAlgo.calcLeastCostPath(startNode, endNode = toLink.getFromNode(), depTime, person, null);
            if (path == null) {
                throw new RuntimeException("No route found from node " + startNode.getId() + " to node " + endNode.getId() + ".");
            }
            double travelTimeLastLink = NetworkUtils.getFreespeedTravelTime(toLink, depTime + path.travelTime);
            double speed = toLink.getLength() / travelTimeLastLink;
            if (speed > this.params.getTeleportedModeFreespeedLimit()) {
                speed = this.params.getTeleportedModeFreespeedLimit();
            }
            travelTimeLastLink = toLink.getLength() / speed;
            travTime = (int)(((double)((int)path.travelTime) + travelTimeLastLink) * this.params.getTeleportedModeFreespeedFactor());
            Route route = this.populationFactory.getRouteFactories().createRoute(Route.class, fromLink.getId(), toLink.getId());
            route.setTravelTime(travTime);
            double dist = 0.0;
            dist = fromAct.getCoord() != null && toAct.getCoord() != null ? CoordUtils.calcEuclideanDistance(fromAct.getCoord(), toAct.getCoord()) : CoordUtils.calcEuclideanDistance(fromLink.getCoord(), toLink.getCoord());
            route.setDistance(dist * this.params.getBeelineDistanceFactor());
            leg.setRoute(route);
        } else {
            Route route = this.populationFactory.getRouteFactories().createRoute(Route.class, fromLink.getId(), toLink.getId());
            route.setTravelTime(0.0);
            route.setDistance(0.0);
            leg.setRoute(route);
            travTime = 0;
        }
        leg.setDepartureTime(depTime);
        leg.setTravelTime(travTime);
        Leg r = leg;
        r.setTravelTime(depTime + (double)travTime - r.getDepartureTime());
        return travTime;
    }
}

