/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.router;

import java.util.Collection;
import java.util.Map;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Node;
import org.matsim.core.router.InitialNode;
import org.matsim.utils.objectattributes.attributable.Attributes;

public class ImaginaryNode
implements Node {
    final Collection<? extends InitialNode> initialNodes;
    final Coord coord;

    ImaginaryNode(Collection<? extends InitialNode> initialNodes, Coord coord) {
        this.initialNodes = initialNodes;
        this.coord = coord;
    }

    ImaginaryNode(Collection<? extends InitialNode> initialNodes) {
        this.initialNodes = initialNodes;
        double sumX = 0.0;
        double sumY = 0.0;
        for (InitialNode initialNode : initialNodes) {
            sumX += initialNode.node.getCoord().getX();
            sumY += initialNode.node.getCoord().getY();
        }
        this.coord = new Coord(sumX /= (double)initialNodes.size(), sumY /= (double)initialNodes.size());
    }

    @Override
    public Coord getCoord() {
        return this.coord;
    }

    @Override
    public Id<Node> getId() {
        return null;
    }

    @Override
    public boolean addInLink(Link link) {
        return false;
    }

    @Override
    public boolean addOutLink(Link link) {
        return false;
    }

    @Override
    public Map<Id<Link>, ? extends Link> getInLinks() {
        return null;
    }

    @Override
    public Map<Id<Link>, ? extends Link> getOutLinks() {
        return null;
    }

    @Override
    public Link removeInLink(Id<Link> linkId) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public Link removeOutLink(Id<Link> outLinkId) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void setCoord(Coord coord) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public Attributes getAttributes() {
        throw new UnsupportedOperationException();
    }
}

