/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.router;

import org.matsim.core.config.Config;
import org.matsim.core.config.groups.ControlerConfigGroup;
import org.matsim.core.controler.AbstractModule;
import org.matsim.core.router.AStarLandmarksFactory;
import org.matsim.core.router.DijkstraFactory;
import org.matsim.core.router.FastAStarLandmarksFactory;
import org.matsim.core.router.FastDijkstraFactory;
import org.matsim.core.router.util.LeastCostPathCalculatorFactory;

public class LeastCostPathCalculatorModule
extends AbstractModule {
    @Override
    public void install() {
        Config config = this.getConfig();
        if (config.controler().getRoutingAlgorithmType().equals((Object)ControlerConfigGroup.RoutingAlgorithmType.Dijkstra)) {
            this.bind(LeastCostPathCalculatorFactory.class).to(DijkstraFactory.class);
        } else if (config.controler().getRoutingAlgorithmType().equals((Object)ControlerConfigGroup.RoutingAlgorithmType.AStarLandmarks)) {
            this.bind(LeastCostPathCalculatorFactory.class).to(AStarLandmarksFactory.class);
        } else if (config.controler().getRoutingAlgorithmType().equals((Object)ControlerConfigGroup.RoutingAlgorithmType.FastDijkstra)) {
            this.bind(LeastCostPathCalculatorFactory.class).to(FastDijkstraFactory.class);
        } else if (config.controler().getRoutingAlgorithmType().equals((Object)ControlerConfigGroup.RoutingAlgorithmType.FastAStarLandmarks)) {
            this.bind(LeastCostPathCalculatorFactory.class).to(FastAStarLandmarksFactory.class);
        }
    }
}

