/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.router;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.Node;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.PlanElement;
import org.matsim.api.core.v01.population.PopulationFactory;
import org.matsim.core.gbl.Gbl;
import org.matsim.core.network.NetworkUtils;
import org.matsim.core.network.algorithms.NetworkInverter;
import org.matsim.core.network.algorithms.NetworkTurnInfoBuilderI;
import org.matsim.core.population.routes.NetworkRoute;
import org.matsim.core.population.routes.RouteUtils;
import org.matsim.core.router.EmptyStageActivityTypes;
import org.matsim.core.router.RoutingModule;
import org.matsim.core.router.StageActivityTypes;
import org.matsim.core.router.costcalculators.TravelDisutilityFactory;
import org.matsim.core.router.util.LeastCostPathCalculator;
import org.matsim.core.router.util.LeastCostPathCalculatorFactory;
import org.matsim.core.router.util.LinkToLinkTravelTime;
import org.matsim.core.router.util.TravelDisutility;
import org.matsim.core.router.util.TravelTime;
import org.matsim.facilities.Facility;
import org.matsim.vehicles.Vehicle;

class LinkToLinkRoutingModule
implements RoutingModule {
    private final Network invertedNetwork;
    private final Network network;
    private final LeastCostPathCalculator leastCostPathCalculator;
    private final PopulationFactory populationFactory;
    private final String mode;

    LinkToLinkRoutingModule(String mode, PopulationFactory populationFactory, Network network, LeastCostPathCalculatorFactory leastCostPathCalcFactory, TravelDisutilityFactory travelCostCalculatorFactory, LinkToLinkTravelTime l2ltravelTimes, NetworkTurnInfoBuilderI turnInfoBuilder) {
        this.network = network;
        this.populationFactory = populationFactory;
        this.mode = mode;
        this.invertedNetwork = new NetworkInverter(network, turnInfoBuilder.createAllowedTurnInfos()).getInvertedNetwork();
        TravelTimesInvertedNetworkProxy invertedTravelTimes = new TravelTimesInvertedNetworkProxy(network, l2ltravelTimes);
        TravelDisutility travelCost = travelCostCalculatorFactory.createTravelDisutility(invertedTravelTimes);
        this.leastCostPathCalculator = leastCostPathCalcFactory.createPathCalculator(this.invertedNetwork, travelCost, invertedTravelTimes);
    }

    @Override
    public List<? extends PlanElement> calcRoute(Facility fromFacility, Facility toFacility, double departureTime, Person person) {
        Leg newLeg = this.populationFactory.createLeg(this.mode);
        Gbl.assertNotNull(fromFacility);
        Gbl.assertNotNull(toFacility);
        if (!toFacility.getLinkId().equals(fromFacility.getLinkId())) {
            Node toInvNode;
            Node fromInvNode = this.invertedNetwork.getNodes().get(Id.create(fromFacility.getLinkId(), Node.class));
            LeastCostPathCalculator.Path invPath = this.leastCostPathCalculator.calcLeastCostPath(fromInvNode, toInvNode = this.invertedNetwork.getNodes().get(Id.create(toFacility.getLinkId(), Node.class)), departureTime, person, null);
            if (invPath == null) {
                throw new RuntimeException("No route found on inverted network from link " + fromFacility.getLinkId() + " to link " + toFacility.getLinkId() + ".");
            }
            LeastCostPathCalculator.Path path = this.invertPath(invPath);
            NetworkRoute route = this.populationFactory.getRouteFactories().createRoute(NetworkRoute.class, fromFacility.getLinkId(), toFacility.getLinkId());
            route.setLinkIds(fromFacility.getLinkId(), NetworkUtils.getLinkIds(path.links), toFacility.getLinkId());
            route.setTravelTime(path.travelTime);
            route.setTravelCost(path.travelCost);
            route.setDistance(RouteUtils.calcDistance(route, 1.0, 1.0, this.network));
            newLeg.setRoute(route);
            newLeg.setTravelTime(path.travelTime);
        } else {
            NetworkRoute route = this.populationFactory.getRouteFactories().createRoute(NetworkRoute.class, fromFacility.getLinkId(), toFacility.getLinkId());
            route.setTravelTime(0.0);
            route.setDistance(0.0);
            newLeg.setRoute(route);
            newLeg.setTravelTime(0.0);
        }
        newLeg.setDepartureTime(departureTime);
        return Arrays.asList(newLeg);
    }

    private LeastCostPathCalculator.Path invertPath(LeastCostPathCalculator.Path invPath) {
        int invLinkCount = invPath.links.size();
        if (invLinkCount == 0) {
            throw new RuntimeException("The path in the inverted network should consist of at least one link.");
        }
        ArrayList<Link> links = new ArrayList<Link>(invLinkCount - 1);
        for (int i = 1; i < invLinkCount; ++i) {
            Id<Link> linkId = Id.create(invPath.nodes.get(i).getId(), Link.class);
            links.add(this.network.getLinks().get(linkId));
        }
        ArrayList<Node> nodes = new ArrayList<Node>(invLinkCount);
        nodes.add(this.network.getNodes().get(Id.create(invPath.links.get(0).getId(), Node.class)));
        for (Link l : links) {
            nodes.add(l.getToNode());
        }
        return new LeastCostPathCalculator.Path(nodes, links, invPath.travelTime, invPath.travelCost);
    }

    @Override
    public StageActivityTypes getStageActivityTypes() {
        return EmptyStageActivityTypes.INSTANCE;
    }

    private static class TravelTimesInvertedNetworkProxy
    implements TravelTime {
        private Network network;
        private LinkToLinkTravelTime linkToLinkTravelTime;

        private TravelTimesInvertedNetworkProxy(Network network, LinkToLinkTravelTime l2ltt) {
            this.linkToLinkTravelTime = l2ltt;
            this.network = network;
        }

        @Override
        public double getLinkTravelTime(Link invLink, double time, Person person, Vehicle vehicle) {
            Link fromLink = this.network.getLinks().get(Id.create(invLink.getFromNode().getId(), Link.class));
            Link toLink = this.network.getLinks().get(Id.create(invLink.getToNode().getId(), Link.class));
            return this.linkToLinkTravelTime.getLinkToLinkTravelTime(fromLink, toLink, time);
        }
    }
}

