/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.router;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.Node;
import org.matsim.core.router.Dijkstra;
import org.matsim.core.router.ImaginaryNode;
import org.matsim.core.router.InitialNode;
import org.matsim.core.router.MultiNodePathCalculator;
import org.matsim.core.router.util.DijkstraNodeData;
import org.matsim.core.router.util.LeastCostPathCalculator;
import org.matsim.core.router.util.PreProcessDijkstra;
import org.matsim.core.router.util.TravelDisutility;
import org.matsim.core.router.util.TravelTime;
import org.matsim.core.utils.collections.RouterPriorityQueue;

public class MultiNodeDijkstra
extends Dijkstra
implements MultiNodePathCalculator {
    private static final Logger log = Logger.getLogger(MultiNodeDijkstra.class);
    private boolean searchAllEndNodes;

    MultiNodeDijkstra(Network network, TravelDisutility costFunction, TravelTime timeFunction, boolean searchAllEndNodes) {
        super(network, costFunction, timeFunction);
        this.searchAllEndNodes = searchAllEndNodes;
    }

    MultiNodeDijkstra(Network network, TravelDisutility costFunction, TravelTime timeFunction, PreProcessDijkstra preProcessData, boolean searchAllEndNodes) {
        super(network, costFunction, timeFunction, preProcessData);
        this.searchAllEndNodes = searchAllEndNodes;
    }

    public static ImaginaryNode createImaginaryNode(Collection<? extends InitialNode> nodes) {
        return new ImaginaryNode(nodes);
    }

    public static ImaginaryNode createImaginaryNode(Collection<? extends InitialNode> nodes, Coord coord) {
        return new ImaginaryNode(nodes, coord);
    }

    @Override
    void checkNodeBelongToNetwork(Node node) {
        if (node instanceof ImaginaryNode) {
            ImaginaryNode imaginaryNode = (ImaginaryNode)node;
            for (InitialNode initialNode : imaginaryNode.initialNodes) {
                super.checkNodeBelongToNetwork(initialNode.node);
            }
        } else {
            super.checkNodeBelongToNetwork(node);
        }
    }

    @Override
    Node searchLogic(Node fromNode, Node toNode, RouterPriorityQueue<Node> pendingNodes) {
        if (toNode instanceof ImaginaryNode) {
            boolean stillSearching;
            HashMap endNodes = new HashMap();
            Collection<? extends InitialNode> initialNodes = ((ImaginaryNode)toNode).initialNodes;
            for (InitialNode initialNode : initialNodes) {
                endNodes.put(initialNode.node.getId(), initialNode);
            }
            double minCost = Double.POSITIVE_INFINITY;
            Node minCostNode = null;
            boolean bl = stillSearching = endNodes.size() > 0;
            while (stillSearching) {
                double cost;
                Node outNode = pendingNodes.poll();
                if (outNode == null) {
                    if (minCostNode == null && log.isTraceEnabled()) {
                        log.trace("No route was found from node " + fromNode.getId() + " to any of the destination nodes was found.");
                        StringBuffer sb = new StringBuffer("\tnot reached destionation nodes: ");
                        for (InitialNode endNode : endNodes.values()) {
                            sb.append(endNode.node.getId().toString());
                            sb.append("; ");
                        }
                        log.trace(sb.toString());
                    }
                    if (this.searchAllEndNodes && endNodes.size() > 0) {
                        for (InitialNode endNode : endNodes.values()) {
                            log.trace("No route was found from node " + fromNode.getId() + " to destination node " + endNode.node.getId() + ".");
                        }
                    }
                    endNodes.clear();
                    stillSearching = false;
                    continue;
                }
                DijkstraNodeData data = this.getData(outNode);
                InitialNode initData = (InitialNode)endNodes.remove(outNode.getId());
                if (initData != null && (cost = data.getCost() + initData.initialCost) < minCost) {
                    minCost = cost;
                    minCostNode = outNode;
                }
                if (this.searchAllEndNodes) {
                    this.relaxNode(outNode, null, pendingNodes);
                    stillSearching = endNodes.size() > 0;
                    continue;
                }
                if (data.getCost() > minCost) {
                    endNodes.clear();
                    stillSearching = false;
                    continue;
                }
                this.relaxNode(outNode, null, pendingNodes);
            }
            return minCostNode;
        }
        return super.searchLogic(fromNode, toNode, pendingNodes);
    }

    @Override
    void initFromNode(Node fromNode, Node toNode, double startTime, RouterPriorityQueue<Node> pendingNodes) {
        if (fromNode instanceof ImaginaryNode) {
            this.relaxImaginaryNode((ImaginaryNode)fromNode, pendingNodes, startTime);
        } else {
            super.initFromNode(fromNode, toNode, startTime, pendingNodes);
        }
    }

    protected void relaxImaginaryNode(ImaginaryNode outNode, RouterPriorityQueue<Node> pendingNodes, double currTime) {
        double currCost = 0.0;
        for (InitialNode initialNode : outNode.initialNodes) {
            double travelTime = initialNode.initialTime;
            double travelCost = initialNode.initialCost;
            DijkstraNodeData data = this.getData(initialNode.node);
            Link l = null;
            this.visitNode(initialNode.node, data, pendingNodes, currTime + travelTime, currCost + travelCost, l);
        }
    }

    @Override
    protected LeastCostPathCalculator.Path constructPath(Node fromNode, Node toNode, double startTime, double arrivalTime) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        ArrayList<Link> links = new ArrayList<Link>();
        nodes.add(0, toNode);
        Link tmpLink = this.getData(toNode).getPrevLink();
        while (tmpLink != null) {
            links.add(0, tmpLink);
            nodes.add(0, tmpLink.getFromNode());
            tmpLink = this.getData(tmpLink.getFromNode()).getPrevLink();
        }
        DijkstraNodeData startNodeData = this.getData((Node)nodes.get(0));
        DijkstraNodeData toNodeData = this.getData(toNode);
        LeastCostPathCalculator.Path path = new LeastCostPathCalculator.Path(nodes, links, toNodeData.getTime() - startNodeData.getTime(), toNodeData.getCost() - startNodeData.getCost());
        return path;
    }

    @Override
    public LeastCostPathCalculator.Path constructPath(Node fromNode, Node toNode, double startTime) {
        if (toNode == null || fromNode == null) {
            return null;
        }
        DijkstraNodeData toData = this.getData(toNode);
        if (!toData.isVisited(this.getIterationId())) {
            return null;
        }
        DijkstraNodeData fromData = this.getData(fromNode);
        if (!fromData.isVisited(this.getIterationId())) {
            return null;
        }
        double arrivalTime = toData.getTime();
        return this.constructPath(fromNode, toNode, startTime, arrivalTime);
    }

    public boolean isSearchAllEndNodes() {
        return this.searchAllEndNodes;
    }

    @Override
    public void setSearchAllEndNodes(boolean searchAllEndNodes) {
        this.searchAllEndNodes = searchAllEndNodes;
    }
}

