/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.router;

import java.util.HashMap;
import java.util.Map;
import org.matsim.api.core.v01.network.Network;
import org.matsim.core.router.MultiNodeDijkstra;
import org.matsim.core.router.util.LeastCostPathCalculator;
import org.matsim.core.router.util.LeastCostPathCalculatorFactory;
import org.matsim.core.router.util.PreProcessDijkstra;
import org.matsim.core.router.util.TravelDisutility;
import org.matsim.core.router.util.TravelTime;

public class MultiNodeDijkstraFactory
implements LeastCostPathCalculatorFactory {
    private final boolean searchAllEndNodes;
    private final boolean usePreProcessData;
    private final Map<Network, PreProcessDijkstra> preProcessData = new HashMap<Network, PreProcessDijkstra>();

    public MultiNodeDijkstraFactory() {
        this.searchAllEndNodes = false;
        this.usePreProcessData = false;
    }

    public MultiNodeDijkstraFactory(boolean searchAllEndNodes) {
        this.searchAllEndNodes = searchAllEndNodes;
        this.usePreProcessData = false;
    }

    public MultiNodeDijkstraFactory(boolean usePreProcessData, boolean searchAllEndNodes) {
        this.usePreProcessData = usePreProcessData;
        this.searchAllEndNodes = searchAllEndNodes;
    }

    @Override
    public synchronized LeastCostPathCalculator createPathCalculator(Network network, TravelDisutility travelCosts, TravelTime travelTimes) {
        if (this.usePreProcessData) {
            PreProcessDijkstra preProcessDijkstra = this.preProcessData.get(network);
            if (preProcessDijkstra == null) {
                preProcessDijkstra = new PreProcessDijkstra();
                preProcessDijkstra.run(network);
                this.preProcessData.put(network, preProcessDijkstra);
            }
            return new MultiNodeDijkstra(network, travelCosts, travelTimes, preProcessDijkstra, this.searchAllEndNodes);
        }
        return new MultiNodeDijkstra(network, travelCosts, travelTimes, this.searchAllEndNodes);
    }
}

