/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.router;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.Node;
import org.matsim.api.core.v01.population.Activity;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.PlanElement;
import org.matsim.api.core.v01.population.PopulationFactory;
import org.matsim.api.core.v01.population.Route;
import org.matsim.core.config.groups.PlanCalcScoreConfigGroup;
import org.matsim.core.gbl.Gbl;
import org.matsim.core.network.NetworkUtils;
import org.matsim.core.population.PopulationUtils;
import org.matsim.core.population.routes.NetworkRoute;
import org.matsim.core.population.routes.RouteUtils;
import org.matsim.core.router.LinkWrapperFacility;
import org.matsim.core.router.RoutingModule;
import org.matsim.core.router.StageActivityTypes;
import org.matsim.core.router.util.LeastCostPathCalculator;
import org.matsim.core.utils.geometry.CoordUtils;
import org.matsim.facilities.FacilitiesUtils;
import org.matsim.facilities.Facility;
import org.matsim.vehicles.Vehicle;
import org.matsim.vehicles.VehicleUtils;

public final class NetworkRoutingInclAccessEgressModule
implements RoutingModule {
    private static final Logger log = Logger.getLogger(NetworkRoutingInclAccessEgressModule.class);
    private final String mode;
    private final PopulationFactory populationFactory;
    private final Network filteredNetwork;
    private final LeastCostPathCalculator routeAlgo;
    private final String stageActivityType;
    private final Scenario scenario;

    NetworkRoutingInclAccessEgressModule(String mode, LeastCostPathCalculator routeAlgo, Scenario scenario, Network filteredNetwork) {
        Gbl.assertNotNull(scenario.getNetwork());
        Gbl.assertIf(scenario.getNetwork().getLinks().size() > 0);
        this.filteredNetwork = filteredNetwork;
        this.routeAlgo = routeAlgo;
        this.mode = mode;
        this.scenario = scenario;
        this.populationFactory = scenario.getPopulation().getFactory();
        this.stageActivityType = PlanCalcScoreConfigGroup.createStageActivityType(mode);
        if (!scenario.getConfig().plansCalcRoute().isInsertingAccessEgressWalk()) {
            throw new RuntimeException("trying to use access/egress but not switched on in config.  currently not supported; there are too many other problems");
        }
    }

    @Override
    public synchronized List<? extends PlanElement> calcRoute(Facility fromFacility, Facility toFacility, double departureTime, Person person) {
        Gbl.assertNotNull(fromFacility);
        Gbl.assertNotNull(toFacility);
        Link accessActLink = FacilitiesUtils.decideOnLink(fromFacility, this.filteredNetwork);
        Link egressActLink = FacilitiesUtils.decideOnLink(toFacility, this.filteredNetwork);
        double now = departureTime;
        ArrayList<PlanElement> result = new ArrayList<PlanElement>();
        now = NetworkRoutingInclAccessEgressModule.addBushwhackingLegFromFacilityToLinkIfNecessary(fromFacility, person, accessActLink, now, result, this.populationFactory, this.stageActivityType);
        Leg newLeg = this.populationFactory.createLeg(this.mode);
        newLeg.setDepartureTime(now);
        now += this.routeLeg(person, newLeg, accessActLink, egressActLink, now);
        result.add(newLeg);
        NetworkRoutingInclAccessEgressModule.addBushwhackingLegFromLinkToFacilityIfNecessary(toFacility, person, egressActLink, now, result, this.populationFactory, this.stageActivityType);
        return result;
    }

    public static void addBushwhackingLegFromLinkToFacilityIfNecessary(Facility toFacility, Person person, Link egressActLink, double now, List<PlanElement> result, PopulationFactory populationFactory, String stageActivityType) {
        Id<Link> endLinkId;
        log.debug("do bushwhacking leg from link=" + egressActLink.getId() + " to facility=" + toFacility.toString());
        if (NetworkRoutingInclAccessEgressModule.isNotNeedingBushwhackingLeg(toFacility)) {
            return;
        }
        Coord startCoord = egressActLink.getToNode().getCoord();
        Gbl.assertNotNull(startCoord);
        Id<Link> startLinkId = egressActLink.getId();
        PlanElement lastPlanElement = result.get(result.size() - 1);
        if (lastPlanElement instanceof Leg) {
            Activity interactionActivity = NetworkRoutingInclAccessEgressModule.createInteractionActivity(startCoord, startLinkId, stageActivityType);
            result.add(interactionActivity);
        }
        if ((endLinkId = toFacility.getLinkId()) == null) {
            endLinkId = startLinkId;
        }
        Leg egressLeg = populationFactory.createLeg("non_network_walk");
        egressLeg.setDepartureTime(now);
        NetworkRoutingInclAccessEgressModule.routeBushwhackingLeg(person, egressLeg, startCoord, toFacility.getCoord(), now, startLinkId, endLinkId, populationFactory);
        result.add(egressLeg);
    }

    private static boolean isNotNeedingBushwhackingLeg(Facility toFacility) {
        if (toFacility.getCoord() == null) {
            return true;
        }
        return toFacility instanceof LinkWrapperFacility;
    }

    public static double addBushwhackingLegFromFacilityToLinkIfNecessary(Facility fromFacility, Person person, Link accessActLink, double now, List<PlanElement> result, PopulationFactory populationFactory, String stageActivityType) {
        if (NetworkRoutingInclAccessEgressModule.isNotNeedingBushwhackingLeg(fromFacility)) {
            return now;
        }
        Coord endCoord = accessActLink.getToNode().getCoord();
        Gbl.assertNotNull(endCoord);
        Leg accessLeg = populationFactory.createLeg("non_network_walk");
        accessLeg.setDepartureTime(now);
        Id<Link> startLinkId = fromFacility.getLinkId();
        if (startLinkId == null) {
            accessActLink.getId();
        }
        now += NetworkRoutingInclAccessEgressModule.routeBushwhackingLeg(person, accessLeg, fromFacility.getCoord(), endCoord, now, startLinkId, accessActLink.getId(), populationFactory);
        result.add(accessLeg);
        Activity interactionActivity = NetworkRoutingInclAccessEgressModule.createInteractionActivity(endCoord, accessActLink.getId(), stageActivityType);
        result.add(interactionActivity);
        return now;
    }

    private static Activity createInteractionActivity(Coord interactionCoord, Id<Link> interactionLink, String stageActivityType) {
        Activity act = PopulationUtils.createActivityFromCoordAndLinkId(stageActivityType, interactionCoord, interactionLink);
        act.setMaximumDuration(0.0);
        return act;
    }

    private static double routeBushwhackingLeg(Person person, Leg leg, Coord fromCoord, Coord toCoord, double depTime, Id<Link> dpLinkId, Id<Link> arLinkId, PopulationFactory pf) {
        double dist = CoordUtils.calcEuclideanDistance(fromCoord, toCoord);
        Route route = pf.getRouteFactories().createRoute(Route.class, dpLinkId, arLinkId);
        double beelineDistanceFactor = 1.3;
        double networkTravelSpeed = 2.0;
        double estimatedNetworkDistance = dist * beelineDistanceFactor;
        int travTime = (int)(estimatedNetworkDistance / networkTravelSpeed);
        route.setTravelTime(travTime);
        route.setDistance(estimatedNetworkDistance);
        leg.setRoute(route);
        leg.setDepartureTime(depTime);
        leg.setTravelTime(travTime);
        return travTime;
    }

    @Override
    public StageActivityTypes getStageActivityTypes() {
        return new AccessEgressStageActivityTypes();
    }

    public String toString() {
        return "[NetworkRoutingModule: mode=" + this.mode + "]";
    }

    double routeLeg(Person person, Leg leg, Link fromLink, Link toLink, double depTime) {
        double travTime;
        Node startNode = fromLink.getToNode();
        Node endNode = toLink.getFromNode();
        if (toLink != fromLink) {
            Id<Vehicle> vehicleId = VehicleUtils.getVehicleId(person, leg.getMode());
            Vehicle vehicle = this.scenario.getVehicles().getVehicles().get(vehicleId);
            LeastCostPathCalculator.Path path = this.routeAlgo.calcLeastCostPath(startNode, endNode, depTime, person, vehicle);
            if (path == null) {
                throw new RuntimeException("No route found from node " + startNode.getId() + " to node " + endNode.getId() + ".");
            }
            NetworkRoute route = this.populationFactory.getRouteFactories().createRoute(NetworkRoute.class, fromLink.getId(), toLink.getId());
            route.setLinkIds(fromLink.getId(), NetworkUtils.getLinkIds(path.links), toLink.getId());
            route.setTravelTime((int)path.travelTime);
            route.setTravelCost(path.travelCost);
            route.setDistance(RouteUtils.calcDistance(route, 1.0, 1.0, this.filteredNetwork));
            leg.setRoute(route);
            travTime = (int)path.travelTime;
        } else {
            NetworkRoute route = this.populationFactory.getRouteFactories().createRoute(NetworkRoute.class, fromLink.getId(), toLink.getId());
            route.setTravelTime(0.0);
            route.setDistance(0.0);
            leg.setRoute(route);
            travTime = 0.0;
        }
        leg.setDepartureTime(depTime);
        leg.setTravelTime(travTime);
        return travTime;
    }

    private final class AccessEgressStageActivityTypes
    implements StageActivityTypes {
        private AccessEgressStageActivityTypes() {
        }

        @Override
        public boolean isStageActivity(String activityType) {
            return activityType.endsWith("interaction") || NetworkRoutingInclAccessEgressModule.this.stageActivityType.equals(activityType);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AccessEgressStageActivityTypes)) {
                return false;
            }
            AccessEgressStageActivityTypes other = (AccessEgressStageActivityTypes)obj;
            return NetworkRoutingInclAccessEgressModule.this.stageActivityType.equals(other.getStageActivityTypeString());
        }

        public int hashCode() {
            return NetworkRoutingInclAccessEgressModule.this.stageActivityType.hashCode();
        }

        private String getStageActivityTypeString() {
            return NetworkRoutingInclAccessEgressModule.this.stageActivityType;
        }
    }
}

