/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.router;

import java.util.Arrays;
import java.util.List;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.Node;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.PlanElement;
import org.matsim.api.core.v01.population.PopulationFactory;
import org.matsim.core.gbl.Gbl;
import org.matsim.core.network.NetworkUtils;
import org.matsim.core.population.routes.NetworkRoute;
import org.matsim.core.population.routes.RouteUtils;
import org.matsim.core.router.EmptyStageActivityTypes;
import org.matsim.core.router.RoutingModule;
import org.matsim.core.router.StageActivityTypes;
import org.matsim.core.router.util.LeastCostPathCalculator;
import org.matsim.facilities.Facility;

public final class NetworkRoutingModule
implements RoutingModule {
    private final String mode;
    private final PopulationFactory populationFactory;
    private final Network network;
    private final LeastCostPathCalculator routeAlgo;

    public NetworkRoutingModule(String mode, PopulationFactory populationFactory, Network network, LeastCostPathCalculator routeAlgo) {
        Gbl.assertNotNull(network);
        this.network = network;
        this.routeAlgo = routeAlgo;
        this.mode = mode;
        this.populationFactory = populationFactory;
    }

    @Override
    public List<? extends PlanElement> calcRoute(Facility fromFacility, Facility toFacility, double departureTime, Person person) {
        Link toLink;
        Leg newLeg = this.populationFactory.createLeg(this.mode);
        Gbl.assertNotNull(fromFacility);
        Gbl.assertNotNull(toFacility);
        Link fromLink = this.network.getLinks().get(fromFacility.getLinkId());
        if (fromLink == null) {
            Gbl.assertNotNull(fromFacility.getCoord());
            fromLink = NetworkUtils.getNearestLink(this.network, fromFacility.getCoord());
        }
        if ((toLink = this.network.getLinks().get(toFacility.getLinkId())) == null) {
            Gbl.assertNotNull(toFacility.getCoord());
            toLink = NetworkUtils.getNearestLink(this.network, toFacility.getCoord());
        }
        Gbl.assertNotNull(fromLink);
        Gbl.assertNotNull(toLink);
        if (toLink != fromLink) {
            Node endNode;
            Node startNode = fromLink.getToNode();
            LeastCostPathCalculator.Path path = this.routeAlgo.calcLeastCostPath(startNode, endNode = toLink.getFromNode(), departureTime, person, null);
            if (path == null) {
                throw new RuntimeException("No route found from node " + startNode.getId() + " to node " + endNode.getId() + " by mode " + this.mode + ".");
            }
            NetworkRoute route = this.populationFactory.getRouteFactories().createRoute(NetworkRoute.class, fromLink.getId(), toLink.getId());
            route.setLinkIds(fromLink.getId(), NetworkUtils.getLinkIds(path.links), toLink.getId());
            route.setTravelTime(path.travelTime);
            route.setTravelCost(path.travelCost);
            route.setDistance(RouteUtils.calcDistance(route, 1.0, 1.0, this.network));
            newLeg.setRoute(route);
            newLeg.setTravelTime(path.travelTime);
        } else {
            NetworkRoute route = this.populationFactory.getRouteFactories().createRoute(NetworkRoute.class, fromLink.getId(), toLink.getId());
            route.setTravelTime(0.0);
            route.setDistance(0.0);
            newLeg.setRoute(route);
            newLeg.setTravelTime(0.0);
        }
        newLeg.setDepartureTime(departureTime);
        return Arrays.asList(newLeg);
    }

    @Override
    public StageActivityTypes getStageActivityTypes() {
        return EmptyStageActivityTypes.INSTANCE;
    }

    public String toString() {
        return "[NetworkRoutingModule: mode=" + this.mode + "]";
    }
}

