/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.router;

import java.util.HashSet;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.population.PopulationFactory;
import org.matsim.core.config.groups.PlansCalcRouteConfigGroup;
import org.matsim.core.network.NetworkUtils;
import org.matsim.core.network.algorithms.TransportModeNetworkFilter;
import org.matsim.core.router.DefaultRoutingModules;
import org.matsim.core.router.RoutingModule;
import org.matsim.core.router.SingleModeNetworksCache;
import org.matsim.core.router.costcalculators.TravelDisutilityFactory;
import org.matsim.core.router.util.LeastCostPathCalculator;
import org.matsim.core.router.util.LeastCostPathCalculatorFactory;
import org.matsim.core.router.util.TravelTime;

public class NetworkRoutingProvider
implements Provider<RoutingModule> {
    private static final Logger log = Logger.getLogger(NetworkRoutingProvider.class);
    private final String routingMode;
    @Inject
    Map<String, TravelTime> travelTimes;
    @Inject
    Map<String, TravelDisutilityFactory> travelDisutilityFactories;
    @Inject
    SingleModeNetworksCache singleModeNetworksCache;
    @Inject
    PlansCalcRouteConfigGroup plansCalcRouteConfigGroup;
    @Inject
    Network network;
    @Inject
    PopulationFactory populationFactory;
    @Inject
    LeastCostPathCalculatorFactory leastCostPathCalculatorFactory;
    @Inject
    Scenario scenario;
    private final String mode;

    public NetworkRoutingProvider(String mode) {
        this(mode, mode);
    }

    public NetworkRoutingProvider(String mode, String routingMode) {
        this.mode = mode;
        this.routingMode = routingMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RoutingModule get() {
        log.debug("requesting network routing module with routingMode=" + this.routingMode + ";\tmode=" + this.mode);
        Network filteredNetwork = null;
        Map<String, Network> map = this.singleModeNetworksCache.getSingleModeNetworksCache();
        synchronized (map) {
            filteredNetwork = this.singleModeNetworksCache.getSingleModeNetworksCache().get(this.mode);
            if (filteredNetwork == null) {
                TransportModeNetworkFilter filter = new TransportModeNetworkFilter(this.network);
                HashSet<String> modes = new HashSet<String>();
                modes.add(this.mode);
                filteredNetwork = NetworkUtils.createNetwork();
                filter.filter(filteredNetwork, modes);
                this.singleModeNetworksCache.getSingleModeNetworksCache().put(this.mode, filteredNetwork);
            }
        }
        TravelDisutilityFactory travelDisutilityFactory = this.travelDisutilityFactories.get(this.routingMode);
        if (travelDisutilityFactory == null) {
            throw new RuntimeException("No TravelDisutilityFactory bound for mode " + this.routingMode + ".");
        }
        TravelTime travelTime = this.travelTimes.get(this.routingMode);
        if (travelTime == null) {
            throw new RuntimeException("No TravelTime bound for mode " + this.routingMode + ".");
        }
        LeastCostPathCalculator routeAlgo = this.leastCostPathCalculatorFactory.createPathCalculator(filteredNetwork, travelDisutilityFactory.createTravelDisutility(travelTime), travelTime);
        if (this.plansCalcRouteConfigGroup.isInsertingAccessEgressWalk()) {
            return DefaultRoutingModules.createAccessEgressNetworkRouter(this.mode, routeAlgo, this.scenario, filteredNetwork);
        }
        return DefaultRoutingModules.createPureNetworkRouter(this.mode, this.populationFactory, filteredNetwork, routeAlgo);
    }
}

