/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.router;

import java.util.List;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.population.Activity;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.api.core.v01.population.PlanElement;
import org.matsim.core.config.Config;
import org.matsim.core.population.algorithms.PersonAlgorithm;
import org.matsim.core.population.algorithms.PlanAlgorithm;
import org.matsim.core.population.routes.NetworkRoute;
import org.matsim.core.router.TripRouter;
import org.matsim.core.router.TripStructureUtils;
import org.matsim.core.utils.misc.Time;
import org.matsim.facilities.ActivityFacilities;
import org.matsim.facilities.FacilitiesUtils;
import org.matsim.vehicles.Vehicle;

public class PlanRouter
implements PlanAlgorithm,
PersonAlgorithm {
    private final TripRouter tripRouter;
    private final ActivityFacilities facilities;

    public PlanRouter(TripRouter tripRouter, ActivityFacilities facilities) {
        this.tripRouter = tripRouter;
        this.facilities = facilities;
    }

    public PlanRouter(TripRouter routingHandler) {
        this(routingHandler, null);
    }

    @Deprecated
    public TripRouter getTripRouter() {
        return this.tripRouter;
    }

    @Override
    public void run(Plan plan) {
        List<TripStructureUtils.Trip> trips = TripStructureUtils.getTrips(plan, this.tripRouter.getStageActivityTypes());
        for (TripStructureUtils.Trip oldTrip : trips) {
            List<? extends PlanElement> newTrip = this.tripRouter.calcRoute(this.tripRouter.getMainModeIdentifier().identifyMainMode(oldTrip.getTripElements()), FacilitiesUtils.toFacility(oldTrip.getOriginActivity(), this.facilities), FacilitiesUtils.toFacility(oldTrip.getDestinationActivity(), this.facilities), PlanRouter.calcEndOfActivity(oldTrip.getOriginActivity(), plan, this.tripRouter.getConfig()), plan.getPerson());
            PlanRouter.putVehicleFromOldTripIntoNewTripIfMeaningful(oldTrip, newTrip);
            TripRouter.insertTrip(plan, oldTrip.getOriginActivity(), newTrip, oldTrip.getDestinationActivity());
        }
    }

    private static void putVehicleFromOldTripIntoNewTripIfMeaningful(TripStructureUtils.Trip oldTrip, List<? extends PlanElement> newTrip) {
        Id<Vehicle> oldVehicleId = PlanRouter.getUniqueVehicleId(oldTrip);
        if (oldVehicleId != null) {
            for (Leg leg : TripStructureUtils.getLegs(newTrip)) {
                if (!(leg.getRoute() instanceof NetworkRoute) || ((NetworkRoute)leg.getRoute()).getVehicleId() != null) continue;
                ((NetworkRoute)leg.getRoute()).setVehicleId(oldVehicleId);
            }
        }
    }

    private static Id<Vehicle> getUniqueVehicleId(TripStructureUtils.Trip trip) {
        Id<Vehicle> vehicleId = null;
        for (Leg leg : trip.getLegsOnly()) {
            if (!(leg.getRoute() instanceof NetworkRoute)) continue;
            if (vehicleId != null && !vehicleId.equals(((NetworkRoute)leg.getRoute()).getVehicleId())) {
                return null;
            }
            vehicleId = ((NetworkRoute)leg.getRoute()).getVehicleId();
        }
        return vehicleId;
    }

    @Override
    public void run(Person person) {
        for (Plan plan : person.getPlans()) {
            this.run(plan);
        }
    }

    public static double calcEndOfActivity(Activity activity, Plan plan, Config config) {
        if (!Time.isUndefinedTime(activity.getEndTime())) {
            return activity.getEndTime();
        }
        double now = 0.0;
        for (PlanElement pe : plan.getPlanElements()) {
            now = TripRouter.calcEndOfPlanElement(now, pe, config);
            if (pe != activity) continue;
            return now;
        }
        throw new RuntimeException("activity " + activity + " not found in " + plan.getPlanElements());
    }
}

