/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.router;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import org.matsim.core.router.StageActivityTypes;

public class StageActivityTypesImpl
implements StageActivityTypes {
    private final SortedSet<String> types = new TreeSet<String>();

    public StageActivityTypesImpl(String type) {
        this(Collections.singleton(type));
    }

    public StageActivityTypesImpl(Collection<String> types) {
        this.types.addAll(types);
    }

    public StageActivityTypesImpl(String ... types) {
        this(Arrays.asList(types));
    }

    @Override
    public boolean isStageActivity(String activityType) {
        return activityType.endsWith("interaction") || this.types.contains(activityType);
    }

    public boolean equals(Object other) {
        if (other != null && other.getClass().equals(this.getClass())) {
            return this.types.equals(((StageActivityTypesImpl)other).types);
        }
        return false;
    }

    public int hashCode() {
        return this.types.hashCode();
    }
}

