/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.router;

import java.util.Arrays;
import java.util.List;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.population.Activity;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.PlanElement;
import org.matsim.api.core.v01.population.Route;
import org.matsim.core.gbl.Gbl;
import org.matsim.core.population.PopulationUtils;
import org.matsim.core.router.EmptyStageActivityTypes;
import org.matsim.core.router.FacilityWrapperActivity;
import org.matsim.core.router.RoutingModule;
import org.matsim.core.router.StageActivityTypes;
import org.matsim.core.utils.geometry.CoordUtils;
import org.matsim.facilities.Facility;

public class TeleportationRoutingModule
implements RoutingModule {
    private final String mode;
    private final double beelineDistanceFactor;
    private final double networkTravelSpeed;
    private final Scenario scenario;

    public TeleportationRoutingModule(String mode, Scenario scenario, double networkTravelSpeed, double beelineDistanceFactor) {
        this.networkTravelSpeed = networkTravelSpeed;
        this.beelineDistanceFactor = beelineDistanceFactor;
        this.mode = mode;
        this.scenario = scenario;
    }

    @Override
    public List<? extends PlanElement> calcRoute(Facility fromFacility, Facility toFacility, double departureTime, Person person) {
        Leg newLeg = this.scenario.getPopulation().getFactory().createLeg(this.mode);
        newLeg.setDepartureTime(departureTime);
        double travTime = this.routeLeg(person, newLeg, new FacilityWrapperActivity(fromFacility), new FacilityWrapperActivity(toFacility), departureTime);
        newLeg.setTravelTime(travTime);
        return Arrays.asList(newLeg);
    }

    @Override
    public StageActivityTypes getStageActivityTypes() {
        return EmptyStageActivityTypes.INSTANCE;
    }

    public String toString() {
        return "[TeleportationRoutingModule: mode=" + this.mode + "]";
    }

    double routeLeg(Person person, Leg leg, Activity fromAct, Activity toAct, double depTime) {
        Coord fromActCoord = PopulationUtils.decideOnCoordForActivity(fromAct, this.scenario);
        Gbl.assertNotNull(fromActCoord);
        Coord toActCoord = PopulationUtils.decideOnCoordForActivity(toAct, this.scenario);
        Gbl.assertNotNull(toActCoord);
        double dist = CoordUtils.calcEuclideanDistance(fromActCoord, toActCoord);
        Route route = this.scenario.getPopulation().getFactory().getRouteFactories().createRoute(Route.class, fromAct.getLinkId(), toAct.getLinkId());
        double estimatedNetworkDistance = dist * this.beelineDistanceFactor;
        int travTime = (int)(estimatedNetworkDistance / this.networkTravelSpeed);
        route.setTravelTime(travTime);
        route.setDistance(estimatedNetworkDistance);
        leg.setRoute(route);
        leg.setDepartureTime(depTime);
        leg.setTravelTime(travTime);
        Leg r = leg;
        r.setTravelTime(depTime + (double)travTime - r.getDepartureTime());
        return travTime;
    }
}

