/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.router;

import java.util.ArrayList;
import java.util.List;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.population.Activity;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.PlanElement;
import org.matsim.api.core.v01.population.Route;
import org.matsim.core.population.PopulationUtils;
import org.matsim.core.population.routes.RouteUtils;
import org.matsim.core.router.RoutingModule;
import org.matsim.core.router.StageActivityTypes;
import org.matsim.core.router.StageActivityTypesImpl;
import org.matsim.facilities.Facility;
import org.matsim.pt.router.TransitRouter;
import org.matsim.pt.routes.ExperimentalTransitRoute;
import org.matsim.pt.transitSchedule.api.TransitSchedule;

public class TransitRouterWrapper
implements RoutingModule {
    private static final StageActivityTypes CHECKER = new StageActivityTypesImpl("pt interaction");
    private final TransitRouter router;
    private final RoutingModule walkRouter;
    private final TransitSchedule transitSchedule;
    private final Network network;

    public TransitRouterWrapper(TransitRouter router, TransitSchedule transitSchedule, Network network, RoutingModule walkRouter) {
        if (router == null) {
            throw new NullPointerException("The router object is null, but is required later.");
        }
        this.router = router;
        this.transitSchedule = transitSchedule;
        this.network = network;
        if (walkRouter == null) {
            throw new NullPointerException("The walkRouter object is null, but is required later.");
        }
        this.walkRouter = walkRouter;
    }

    @Override
    public List<? extends PlanElement> calcRoute(Facility fromFacility, Facility toFacility, double departureTime, Person person) {
        List<Leg> baseTrip = this.router.calcRoute(fromFacility, toFacility, departureTime, person);
        return baseTrip != null ? this.fillWithActivities(baseTrip, fromFacility, toFacility, departureTime, person) : this.walkRouter.calcRoute(fromFacility, toFacility, departureTime, person);
    }

    private List<PlanElement> fillWithActivities(List<Leg> baseTrip, Facility fromFacility, Facility toFacility, double departureTime, Person person) {
        ArrayList<PlanElement> trip = new ArrayList<PlanElement>();
        Coord nextCoord = null;
        int i = 0;
        for (Leg leg : baseTrip) {
            ExperimentalTransitRoute tRoute;
            if (i == 0) {
                Facility firstToFacility;
                if (baseTrip.size() > 1) {
                    ExperimentalTransitRoute tRoute2 = (ExperimentalTransitRoute)baseTrip.get(1).getRoute();
                    firstToFacility = this.transitSchedule.getFacilities().get(tRoute2.getAccessStopId());
                } else {
                    firstToFacility = toFacility;
                }
                Route route = this.createWalkRoute(fromFacility, departureTime, person, leg.getTravelTime(), firstToFacility);
                leg.setRoute(route);
            } else if (leg.getRoute() instanceof ExperimentalTransitRoute) {
                tRoute = (ExperimentalTransitRoute)leg.getRoute();
                tRoute.setTravelTime(leg.getTravelTime());
                tRoute.setDistance(RouteUtils.calcDistance(tRoute, this.transitSchedule, this.network));
                Activity act = PopulationUtils.createActivityFromCoordAndLinkId("pt interaction", this.transitSchedule.getFacilities().get(tRoute.getAccessStopId()).getCoord(), tRoute.getStartLinkId());
                act.setMaximumDuration(0.0);
                trip.add(act);
                nextCoord = this.transitSchedule.getFacilities().get(tRoute.getEgressStopId()).getCoord();
            } else {
                if (i == baseTrip.size() - 1) {
                    tRoute = (ExperimentalTransitRoute)baseTrip.get(baseTrip.size() - 2).getRoute();
                    Facility lastFromFacility = this.transitSchedule.getFacilities().get(tRoute.getEgressStopId());
                    Route route = this.createWalkRoute(lastFromFacility, departureTime, person, leg.getTravelTime(), toFacility);
                    leg.setRoute(route);
                }
                Activity act = PopulationUtils.createActivityFromCoordAndLinkId("pt interaction", nextCoord, leg.getRoute().getStartLinkId());
                act.setMaximumDuration(0.0);
                trip.add(act);
            }
            trip.add(leg);
            ++i;
        }
        return trip;
    }

    private Route createWalkRoute(Facility fromFacility, double departureTime, Person person, double travelTime, Facility firstToFacility) {
        Route route = RouteUtils.createGenericRouteImpl(fromFacility.getLinkId(), firstToFacility.getLinkId());
        List<? extends PlanElement> walkRoute = this.walkRouter.calcRoute(fromFacility, firstToFacility, departureTime, person);
        route.setDistance(((Leg)walkRoute.get(0)).getRoute().getDistance());
        route.setTravelTime(travelTime);
        return route;
    }

    @Override
    public StageActivityTypes getStageActivityTypes() {
        return CHECKER;
    }
}

