/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.router;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.population.Activity;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.api.core.v01.population.PlanElement;
import org.matsim.core.api.internal.MatsimExtensionPoint;
import org.matsim.core.config.Config;
import org.matsim.core.gbl.Gbl;
import org.matsim.core.population.PopulationUtils;
import org.matsim.core.router.CompositeStageActivityTypes;
import org.matsim.core.router.MainModeIdentifier;
import org.matsim.core.router.MainModeIdentifierImpl;
import org.matsim.core.router.RoutingModule;
import org.matsim.core.router.StageActivityTypes;
import org.matsim.core.utils.misc.Time;
import org.matsim.facilities.Facility;

public final class TripRouter
implements MatsimExtensionPoint {
    private static final Logger log = Logger.getLogger(TripRouter.class);
    private final Map<String, RoutingModule> routingModules = new HashMap<String, RoutingModule>();
    private final CompositeStageActivityTypes checker = new CompositeStageActivityTypes();
    private MainModeIdentifier mainModeIdentifier = new MainModeIdentifierImpl();
    private Config config;

    @Inject
    TripRouter(Map<String, Provider<RoutingModule>> routingModuleProviders, MainModeIdentifier mainModeIdentifier, Config config) {
        for (Map.Entry<String, Provider<RoutingModule>> entry : routingModuleProviders.entrySet()) {
            this.setRoutingModule(entry.getKey(), entry.getValue().get());
        }
        this.setMainModeIdentifier(mainModeIdentifier);
        this.config = config;
    }

    @Deprecated
    RoutingModule setRoutingModule(String mainMode, RoutingModule module) {
        StageActivityTypes oldTypes;
        boolean removed;
        RoutingModule old = this.routingModules.put(mainMode, module);
        if (old != null && !(removed = this.checker.removeActivityTypes(oldTypes = old.getStageActivityTypes()))) {
            throw new RuntimeException("could not remove " + oldTypes + " associated to " + old + ". This may be due to a routing module creating a new instance at each call of getStageActivityTypes()");
        }
        StageActivityTypes types = module.getStageActivityTypes();
        if (types == null) {
            throw new RuntimeException(module + " returns null stage activity types. This is not a valid value. Return EmptyStageActivityTypes.INSTANCE instead.");
        }
        this.checker.addActivityTypes(types);
        return old;
    }

    public RoutingModule getRoutingModule(String mainMode) {
        return this.routingModules.get(mainMode);
    }

    public Set<String> getRegisteredModes() {
        return Collections.unmodifiableSet(this.routingModules.keySet());
    }

    public StageActivityTypes getStageActivityTypes() {
        return this.checker;
    }

    @Deprecated
    MainModeIdentifier setMainModeIdentifier(MainModeIdentifier newIdentifier) {
        MainModeIdentifier old = this.mainModeIdentifier;
        this.mainModeIdentifier = newIdentifier;
        return old;
    }

    public MainModeIdentifier getMainModeIdentifier() {
        return this.mainModeIdentifier;
    }

    public synchronized List<? extends PlanElement> calcRoute(String mainMode, Facility fromFacility, Facility toFacility, double departureTime, Person person) {
        Gbl.assertNotNull(fromFacility);
        Gbl.assertNotNull(toFacility);
        RoutingModule module = this.routingModules.get(mainMode);
        if (module != null) {
            List<? extends PlanElement> trip = module.calcRoute(fromFacility, toFacility, departureTime, person);
            if (trip == null) {
                throw new NullPointerException("Routing module " + module + " returned a null Trip for main mode " + mainMode);
            }
            return trip;
        }
        throw new UnknownModeException("unregistered main mode |" + mainMode + "|: does not pertain to " + this.routingModules.keySet());
    }

    public static double calcEndOfPlanElement(double now, PlanElement pe, Config config) {
        if (Time.isUndefinedTime(now)) {
            throw new RuntimeException("got undefined now to update with plan element" + pe);
        }
        if (pe instanceof Activity) {
            Activity act = (Activity)pe;
            return PopulationUtils.decideOnActivityEndTime(act, now, config);
        }
        double ttime = PopulationUtils.decideOnTravelTimeForLeg((Leg)pe);
        if (Time.isUndefinedTime(ttime)) {
            ttime = 0.0;
        }
        return now + ttime;
    }

    public static List<PlanElement> insertTrip(Plan plan, Activity origin, List<? extends PlanElement> trip, Activity destination) {
        return TripRouter.insertTrip(plan.getPlanElements(), origin, trip, destination);
    }

    public static List<PlanElement> insertTrip(List<PlanElement> plan, Activity origin, List<? extends PlanElement> trip, Activity destination) {
        int indexOfOrigin = -1;
        int indexOfDestination = -1;
        int currentIndex = 0;
        for (PlanElement pe : plan) {
            if (pe == origin) {
                indexOfOrigin = currentIndex;
            }
            if (pe == destination) {
                indexOfDestination = currentIndex;
                if (indexOfDestination >= indexOfOrigin) break;
                throw new RuntimeException("destination " + destination + " found before origin " + origin + " in " + plan);
            }
            ++currentIndex;
        }
        if (indexOfOrigin < 0) {
            throw new RuntimeException("could not find origin " + origin + " in " + plan);
        }
        if (indexOfDestination < 0) {
            throw new RuntimeException("could not find destination " + destination + " in " + plan);
        }
        List<PlanElement> seq = plan.subList(indexOfOrigin + 1, indexOfDestination);
        ArrayList<PlanElement> oldTrip = new ArrayList<PlanElement>(seq);
        seq.clear();
        assert (trip != null);
        seq.addAll(trip);
        return oldTrip;
    }

    public Config getConfig() {
        return this.config;
    }

    public static class UnknownModeException
    extends RuntimeException {
        private UnknownModeException(String msg) {
            super(msg);
        }
    }

    public static final class Builder {
        private final Config config;
        private MainModeIdentifier mainModeIdentifier = new MainModeIdentifierImpl();
        private Map<String, Provider<RoutingModule>> routingModuleProviders = new LinkedHashMap<String, Provider<RoutingModule>>();

        public Builder(Config config) {
            this.config = config;
        }

        public Builder setMainModeIdentifier(MainModeIdentifier identifier) {
            this.mainModeIdentifier = identifier;
            return this;
        }

        public Builder setRoutingModule(String mainMode, final RoutingModule routingModule) {
            this.routingModuleProviders.put(mainMode, new Provider<RoutingModule>(){

                @Override
                public RoutingModule get() {
                    return routingModule;
                }
            });
            return this;
        }

        public TripRouter build() {
            return new TripRouter(this.routingModuleProviders, this.mainModeIdentifier, this.config);
        }
    }
}

