/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.router;

import java.util.Arrays;
import javax.inject.Provider;
import org.matsim.api.core.v01.Scenario;
import org.matsim.core.controler.AbstractModule;
import org.matsim.core.controler.Injector;
import org.matsim.core.events.EventsManagerModule;
import org.matsim.core.router.LeastCostPathCalculatorModule;
import org.matsim.core.router.TripRouter;
import org.matsim.core.router.TripRouterModule;
import org.matsim.core.router.costcalculators.TravelDisutilityFactory;
import org.matsim.core.router.costcalculators.TravelDisutilityModule;
import org.matsim.core.router.util.LeastCostPathCalculatorFactory;
import org.matsim.core.router.util.TravelDisutility;
import org.matsim.core.router.util.TravelTime;
import org.matsim.core.scenario.ScenarioByInstanceModule;
import org.matsim.core.trafficmonitoring.TravelTimeCalculatorModule;
import org.matsim.pt.router.TransitRouter;
import org.matsim.pt.router.TransitRouterModule;

public class TripRouterFactoryBuilderWithDefaults {
    private Provider<TransitRouter> transitRouterFactory;
    private LeastCostPathCalculatorFactory leastCostPathCalculatorFactory;
    private TravelTime carTravelTime;
    private TravelDisutility carTravelDisutility;

    public static Provider<TripRouter> createTripRouterProvider(Scenario scenario, LeastCostPathCalculatorFactory leastCostAlgoFactory, Provider<TransitRouter> transitRouterFactory) {
        TripRouterFactoryBuilderWithDefaults builder = new TripRouterFactoryBuilderWithDefaults();
        builder.setLeastCostPathCalculatorFactory(leastCostAlgoFactory);
        builder.setTransitRouterFactory(transitRouterFactory);
        return builder.build(scenario);
    }

    public void setTransitRouterFactory(Provider<TransitRouter> transitRouterFactory) {
        this.transitRouterFactory = transitRouterFactory;
    }

    public void setLeastCostPathCalculatorFactory(LeastCostPathCalculatorFactory leastCostPathCalculatorFactory) {
        this.leastCostPathCalculatorFactory = leastCostPathCalculatorFactory;
    }

    public Provider<TripRouter> build(Scenario scenario) {
        return Injector.createInjector(scenario.getConfig(), AbstractModule.override(Arrays.asList(new ScenarioByInstanceModule(scenario), new TripRouterModule(), new TravelDisutilityModule(), new TravelTimeCalculatorModule(), new EventsManagerModule()), new AbstractModule(){

            @Override
            public void install() {
                if (TripRouterFactoryBuilderWithDefaults.this.leastCostPathCalculatorFactory != null) {
                    this.bind(LeastCostPathCalculatorFactory.class).toInstance(TripRouterFactoryBuilderWithDefaults.this.leastCostPathCalculatorFactory);
                }
                if (TripRouterFactoryBuilderWithDefaults.this.transitRouterFactory != null && this.getConfig().transit().isUseTransit()) {
                    this.bind(TransitRouter.class).toProvider(TripRouterFactoryBuilderWithDefaults.this.transitRouterFactory);
                }
                if (TripRouterFactoryBuilderWithDefaults.this.carTravelDisutility != null) {
                    this.addTravelDisutilityFactoryBinding("car").toInstance(new TravelDisutilityFactory(){

                        @Override
                        public TravelDisutility createTravelDisutility(TravelTime timeCalculator) {
                            return TripRouterFactoryBuilderWithDefaults.this.carTravelDisutility;
                        }
                    });
                }
                if (TripRouterFactoryBuilderWithDefaults.this.carTravelTime != null) {
                    this.addTravelTimeBinding("car").toInstance(TripRouterFactoryBuilderWithDefaults.this.carTravelTime);
                }
            }
        })).getProvider(TripRouter.class);
    }

    public static Provider<TripRouter> createDefaultTripRouterFactoryImpl(final Scenario scenario) {
        return Injector.createInjector(scenario.getConfig(), new TripRouterModule(), new TravelDisutilityModule(), new TravelTimeCalculatorModule(), new EventsManagerModule(), new AbstractModule(){

            @Override
            public void install() {
                this.install(new ScenarioByInstanceModule(scenario));
            }
        }).getProvider(TripRouter.class);
    }

    public static Provider<TransitRouter> createDefaultTransitRouter(final Scenario scenario) {
        return Injector.createInjector(scenario.getConfig(), new TransitRouterModule(), new AbstractModule(){

            @Override
            public void install() {
                this.install(new ScenarioByInstanceModule(scenario));
            }
        }).getProvider(TransitRouter.class);
    }

    public static LeastCostPathCalculatorFactory createDefaultLeastCostPathCalculatorFactory(Scenario scenario) {
        return Injector.createInjector(scenario.getConfig(), new ScenarioByInstanceModule(scenario), new EventsManagerModule(), new TravelDisutilityModule(), new TravelTimeCalculatorModule(), new LeastCostPathCalculatorModule()).getInstance(LeastCostPathCalculatorFactory.class);
    }

    public void setTravelTime(TravelTime travelTime) {
        this.carTravelTime = travelTime;
    }

    public void setTravelDisutility(TravelDisutility travelDisutility) {
        this.carTravelDisutility = travelDisutility;
    }
}

