/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.router;

import com.google.inject.Key;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import org.matsim.core.config.groups.PlansCalcRouteConfigGroup;
import org.matsim.core.controler.AbstractModule;
import org.matsim.core.network.algorithms.NetworkTurnInfoBuilder;
import org.matsim.core.network.algorithms.NetworkTurnInfoBuilderI;
import org.matsim.core.router.BeelineTeleportationRouting;
import org.matsim.core.router.FreespeedFactorRouting;
import org.matsim.core.router.LeastCostPathCalculatorModule;
import org.matsim.core.router.LinkToLinkRouting;
import org.matsim.core.router.MainModeIdentifier;
import org.matsim.core.router.MainModeIdentifierImpl;
import org.matsim.core.router.NetworkRoutingProvider;
import org.matsim.core.router.RoutingModule;
import org.matsim.core.router.SingleModeNetworksCache;
import org.matsim.core.router.Transit;
import org.matsim.core.router.TripRouter;
import org.matsim.pt.router.TransitRouterModule;

public class TripRouterModule
extends AbstractModule {
    @Override
    public void install() {
        this.bind(TripRouter.class);
        this.bind(MainModeIdentifier.class).to(MainModeIdentifierImpl.class);
        this.install(new LeastCostPathCalculatorModule());
        this.install(new TransitRouterModule());
        this.bind(SingleModeNetworksCache.class).asEagerSingleton();
        PlansCalcRouteConfigGroup routeConfigGroup = this.getConfig().plansCalcRoute();
        for (String mode : routeConfigGroup.getTeleportedModeFreespeedFactors().keySet()) {
            if (this.getConfig().transit().isUseTransit() && this.getConfig().transit().getTransitModes().contains(mode)) continue;
            this.addRoutingModuleBinding(mode).toProvider(new FreespeedFactorRouting(this.getConfig().plansCalcRoute().getModeRoutingParams().get(mode)));
        }
        for (String mode : routeConfigGroup.getTeleportedModeSpeeds().keySet()) {
            this.addRoutingModuleBinding(mode).toProvider(new BeelineTeleportationRouting(this.getConfig().plansCalcRoute().getModeRoutingParams().get(mode)));
        }
        boolean linkToLinkRouting = this.getConfig().controler().isLinkToLinkRoutingEnabled();
        if (linkToLinkRouting) {
            this.bind(NetworkTurnInfoBuilderI.class).to(NetworkTurnInfoBuilder.class);
        }
        for (String mode : routeConfigGroup.getNetworkModes()) {
            this.addRoutingModuleBinding(mode).toProvider(linkToLinkRouting ? new LinkToLinkRouting(mode) : new NetworkRoutingProvider(mode));
        }
        if (this.getConfig().transit().isUseTransit()) {
            for (String mode : this.getConfig().transit().getTransitModes()) {
                this.addRoutingModuleBinding(mode).toProvider(Transit.class);
            }
            this.addRoutingModuleBinding("transit_walk").to(Key.get(RoutingModule.class, (Annotation)Names.named("walk")));
        }
    }
}

