/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.router;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.Identifiable;
import org.matsim.api.core.v01.population.Activity;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.api.core.v01.population.PlanElement;
import org.matsim.core.gbl.Gbl;
import org.matsim.core.router.StageActivityTypes;
import org.matsim.facilities.ActivityFacility;

public class TripStructureUtils {
    private TripStructureUtils() {
    }

    public static List<Leg> getLegs(Plan plan) {
        return TripStructureUtils.getLegs(plan.getPlanElements());
    }

    public static List<Leg> getLegs(List<? extends PlanElement> planElements) {
        ArrayList<Leg> legs = new ArrayList<Leg>();
        for (PlanElement planElement : planElements) {
            if (!(planElement instanceof Leg)) continue;
            legs.add((Leg)planElement);
        }
        return Collections.unmodifiableList(legs);
    }

    public static List<Activity> getActivities(Plan plan, StageActivityTypes stageActivities) {
        return TripStructureUtils.getActivities(plan.getPlanElements(), stageActivities);
    }

    public static List<Activity> getActivities(List<? extends PlanElement> planElements, StageActivityTypes stageActivities) {
        ArrayList<Activity> activities = new ArrayList<Activity>();
        for (PlanElement planElement : planElements) {
            if (!(planElement instanceof Activity)) continue;
            Activity act = (Activity)planElement;
            if (stageActivities != null && stageActivities.isStageActivity(act.getType())) continue;
            activities.add(act);
        }
        return Collections.unmodifiableList(activities);
    }

    public static List<Trip> getTrips(Plan plan, StageActivityTypes stageActivities) {
        return TripStructureUtils.getTrips(plan.getPlanElements(), stageActivities);
    }

    public static List<Trip> getTrips(List<? extends PlanElement> planElements, StageActivityTypes stageActivities) {
        ArrayList<Trip> trips = new ArrayList<Trip>();
        int originActivityIndex = -1;
        int currentIndex = -1;
        for (PlanElement planElement : planElements) {
            Activity act;
            ++currentIndex;
            if (!(planElement instanceof Activity) || stageActivities.isStageActivity((act = (Activity)planElement).getType())) continue;
            if (currentIndex - originActivityIndex > 1) {
                trips.add(new Trip((Activity)planElements.get(originActivityIndex), Collections.unmodifiableList(new ArrayList<PlanElement>(planElements.subList(originActivityIndex + 1, currentIndex))), act));
            }
            originActivityIndex = currentIndex;
        }
        return Collections.unmodifiableList(trips);
    }

    public static Collection<Subtour> getSubtours(Plan plan, StageActivityTypes stageActivityTypes) {
        return TripStructureUtils.getSubtours(plan.getPlanElements(), stageActivityTypes);
    }

    public static Collection<Subtour> getSubtours(List<? extends PlanElement> planElements, StageActivityTypes stageActivityTypes) {
        ArrayList<Subtour> subtours = new ArrayList<Subtour>();
        Id<Identifiable<ActivityFacility>> destinationId = null;
        ArrayList<Id<Identifiable<ActivityFacility>>> originIds = new ArrayList<Id<Identifiable<ActivityFacility>>>();
        List<Trip> trips = TripStructureUtils.getTrips(planElements, stageActivityTypes);
        ArrayList<Trip> nonAllocatedTrips = new ArrayList<Trip>(trips);
        for (Trip trip : trips) {
            Id<Identifiable<ActivityFacility>> originId = trip.getOriginActivity().getFacilityId() != null ? trip.getOriginActivity().getFacilityId() : trip.getOriginActivity().getLinkId();
            if (originId == null) {
                throw new NullPointerException("Both facility id and link id for origin activity " + trip.getOriginActivity() + " are null!");
            }
            if (destinationId != null && !originId.equals(destinationId)) {
                throw new RuntimeException("unconsistent trip location sequence: " + destinationId + " != " + originId);
            }
            destinationId = trip.getDestinationActivity().getFacilityId() != null ? trip.getDestinationActivity().getFacilityId() : trip.getDestinationActivity().getLinkId();
            if (destinationId == null) {
                throw new NullPointerException("Both facility id and link id for destination activity " + trip.getDestinationActivity() + " are null!");
            }
            originIds.add(originId);
            if (!originIds.contains(destinationId)) continue;
            int subtourStartIndex = originIds.lastIndexOf(destinationId);
            int subtourEndIndex = originIds.size();
            ArrayList<Trip> subtour = new ArrayList<Trip>(trips.subList(subtourStartIndex, subtourEndIndex));
            nonAllocatedTrips.removeAll(subtour);
            for (int i = subtourStartIndex; i < subtourEndIndex; ++i) {
                originIds.set(i, null);
            }
            TripStructureUtils.addSubtourAndUpdateParents(subtours, new Subtour(subtourStartIndex, subtourEndIndex, subtour, true));
        }
        if (nonAllocatedTrips.size() != 0) {
            TripStructureUtils.addSubtourAndUpdateParents(subtours, new Subtour(0, trips.size(), new ArrayList<Trip>(trips), false));
        }
        return Collections.unmodifiableList(subtours);
    }

    private static void addSubtourAndUpdateParents(List<Subtour> subtours, Subtour newSubtour) {
        for (Subtour existingSubtour : subtours) {
            if (existingSubtour.parent != null || existingSubtour.startIndex < newSubtour.startIndex || existingSubtour.endIndex < newSubtour.startIndex) continue;
            assert (existingSubtour.startIndex < newSubtour.endIndex);
            assert (existingSubtour.endIndex <= newSubtour.endIndex);
            existingSubtour.parent = newSubtour;
            newSubtour.children.add(existingSubtour);
        }
        subtours.add(newSubtour);
    }

    public static double getDepartureTime(Trip trip) {
        Leg leg = (Leg)trip.getTripElements().get(0);
        return leg.getDepartureTime();
    }

    @Deprecated
    public static Trip findCurrentTrip(PlanElement pe, Plan plan, StageActivityTypes sat) {
        return TripStructureUtils.findTripAtPlanElement(pe, plan, sat);
    }

    public static Trip findTripAtPlanElement(PlanElement currentPlanElement, Plan plan, StageActivityTypes stageActivities) {
        if (currentPlanElement instanceof Activity) {
            Gbl.assertIf(stageActivities.isStageActivity(((Activity)currentPlanElement).getType()));
        }
        List<Trip> trips = TripStructureUtils.getTrips(plan.getPlanElements(), stageActivities);
        for (Trip trip : trips) {
            int index = trip.getTripElements().indexOf(currentPlanElement);
            if (index == -1) continue;
            return trip;
        }
        return null;
    }

    public static Trip findTripEndingAtActivity(Activity activity, Plan plan, StageActivityTypes stageActivities) {
        Gbl.assertIf(!stageActivities.isStageActivity(activity.getType()));
        List<Trip> trips = TripStructureUtils.getTrips(plan.getPlanElements(), stageActivities);
        for (Trip trip : trips) {
            if (!activity.equals(trip.getDestinationActivity())) continue;
            return trip;
        }
        return null;
    }

    public static Trip findTripStartingAtActivity(Activity activity, Plan plan, StageActivityTypes stageActivities) {
        Gbl.assertIf(!stageActivities.isStageActivity(activity.getType()));
        List<Trip> trips = TripStructureUtils.getTrips(plan, stageActivities);
        for (Trip trip : trips) {
            if (!trip.getOriginActivity().equals(activity)) continue;
            return trip;
        }
        return null;
    }

    public static final class Subtour {
        private final int startIndex;
        private final int endIndex;
        private final List<Trip> trips;
        private final boolean isClosed;
        Subtour parent = null;
        final List<Subtour> children = new ArrayList<Subtour>();

        Subtour(List<Trip> trips, boolean isClosed) {
            this(-1, -1, trips, isClosed);
        }

        private Subtour(int startIndex, int endIndex, List<Trip> trips, boolean isClosed) {
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.trips = Collections.unmodifiableList(trips);
            this.isClosed = isClosed;
        }

        public List<Trip> getTrips() {
            return this.trips;
        }

        public List<Trip> getTripsWithoutSubSubtours() {
            ArrayList<Trip> list = new ArrayList<Trip>();
            for (Trip t : this.trips) {
                boolean isInChildSt = false;
                for (Subtour child : this.children) {
                    if (!child.contains(t)) continue;
                    isInChildSt = true;
                    break;
                }
                if (isInChildSt) continue;
                list.add(t);
            }
            return list;
        }

        private boolean contains(Trip t) {
            return this.trips.contains(t);
        }

        public Subtour getParent() {
            return this.parent;
        }

        public Collection<Subtour> getChildren() {
            return Collections.unmodifiableList(this.children);
        }

        public boolean isClosed() {
            return this.isClosed;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (!other.getClass().equals(this.getClass())) {
                return false;
            }
            Subtour s2 = (Subtour)other;
            return s2.trips.equals(this.trips) && Subtour.areChildrenCompatible(this.children, s2.children) && (s2.parent == null ? this.parent == null : s2.parent.equals(this.parent)) && s2.isClosed == this.isClosed;
        }

        private static boolean areChildrenCompatible(List<Subtour> children2, List<Subtour> children3) {
            return children2.size() == children3.size();
        }

        public int hashCode() {
            return this.trips.hashCode();
        }

        public String toString() {
            return "Subtour: " + this.trips.toString();
        }
    }

    public static final class Trip {
        private final Activity originActivity;
        private final Activity destinationActivity;
        private final List<PlanElement> trip;
        private final List<Leg> legs;

        Trip(Activity originActivity, List<PlanElement> trip, Activity destinationActivity) {
            this.originActivity = originActivity;
            this.trip = trip;
            this.legs = Trip.extractLegs(trip);
            this.destinationActivity = destinationActivity;
        }

        private static List<Leg> extractLegs(List<PlanElement> trip) {
            ArrayList<Leg> legs = new ArrayList<Leg>();
            for (PlanElement pe : trip) {
                if (!(pe instanceof Leg)) continue;
                legs.add((Leg)pe);
            }
            return Collections.unmodifiableList(legs);
        }

        public Activity getOriginActivity() {
            return this.originActivity;
        }

        public Activity getDestinationActivity() {
            return this.destinationActivity;
        }

        public List<PlanElement> getTripElements() {
            return this.trip;
        }

        public List<Leg> getLegsOnly() {
            return this.legs;
        }

        public String toString() {
            return "{Trip: origin=" + this.originActivity + "; " + "trip=" + this.trip + "; " + "destination=" + this.destinationActivity + "}";
        }

        public boolean equals(Object other) {
            if (!(other instanceof Trip)) {
                return false;
            }
            Trip otherTrip = (Trip)other;
            return otherTrip.originActivity.equals(this.originActivity) && otherTrip.trip.equals(this.trip) && otherTrip.destinationActivity.equals(this.destinationActivity);
        }

        public int hashCode() {
            return this.originActivity.hashCode() + this.trip.hashCode() + this.destinationActivity.hashCode();
        }
    }
}

