/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.router.costcalculators;

import org.apache.log4j.Logger;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.config.groups.PlanCalcScoreConfigGroup;
import org.matsim.core.router.util.LinkToLinkTravelTime;
import org.matsim.core.router.util.TravelDisutility;
import org.matsim.core.router.util.TravelTime;
import org.matsim.vehicles.Vehicle;

public class FreespeedTravelTimeAndDisutility
implements TravelDisutility,
TravelTime,
LinkToLinkTravelTime {
    private static final Logger log = Logger.getLogger(FreespeedTravelTimeAndDisutility.class);
    private final double travelCostFactor;
    private final double marginalUtlOfDistance;
    private static int wrnCnt = 0;

    public FreespeedTravelTimeAndDisutility(double scaledMarginalUtilityOfTraveling, double scaledMarginalUtilityOfPerforming, double scaledMarginalUtilityOfDistance) {
        this.travelCostFactor = -scaledMarginalUtilityOfTraveling + scaledMarginalUtilityOfPerforming;
        if (wrnCnt < 1) {
            ++wrnCnt;
            if (this.travelCostFactor <= 0.0) {
                log.warn("The travel cost in " + this.getClass().getName() + " under normal circumstances should be > 0. " + "Currently, it is " + this.travelCostFactor + "." + "That is the sum of the costs for traveling and the opportunity costs." + " Please adjust the parameters" + "'traveling' and 'performing' in the module 'planCalcScore' in your config file to be" + " lower or equal than 0 when added.");
                log.warn(" This message given only once.");
            }
        }
        this.marginalUtlOfDistance = scaledMarginalUtilityOfDistance;
    }

    public FreespeedTravelTimeAndDisutility(PlanCalcScoreConfigGroup cnScoringGroup) {
        this(cnScoringGroup.getModes().get("car").getMarginalUtilityOfTraveling() / 3600.0, cnScoringGroup.getPerforming_utils_hr() / 3600.0, cnScoringGroup.getModes().get("car").getMonetaryDistanceRate() * cnScoringGroup.getMarginalUtilityOfMoney());
    }

    @Override
    public double getLinkTravelDisutility(Link link, double time, Person person, Vehicle vehicle) {
        if (this.marginalUtlOfDistance == 0.0) {
            return link.getLength() / link.getFreespeed(time) * this.travelCostFactor;
        }
        return link.getLength() / link.getFreespeed(time) * this.travelCostFactor - this.marginalUtlOfDistance * link.getLength();
    }

    @Override
    public double getLinkMinimumTravelDisutility(Link link) {
        if (this.marginalUtlOfDistance == 0.0) {
            return link.getLength() / link.getFreespeed() * this.travelCostFactor;
        }
        return link.getLength() / link.getFreespeed() * this.travelCostFactor - this.marginalUtlOfDistance * link.getLength();
    }

    @Override
    public double getLinkTravelTime(Link link, double time, Person person, Vehicle vehicle) {
        return link.getLength() / link.getFreespeed(time);
    }

    @Override
    public double getLinkToLinkTravelTime(Link fromLink, Link toLink, double time) {
        return this.getLinkTravelTime(fromLink, time, null, null);
    }
}

