/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.router.costcalculators;

import org.apache.log4j.Logger;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.router.util.TravelDisutility;
import org.matsim.core.router.util.TravelTime;
import org.matsim.core.trafficmonitoring.FreeSpeedTravelTime;
import org.matsim.vehicles.Vehicle;

public class OnlyTimeDependentTravelDisutility
implements TravelDisutility {
    private static final Logger log = Logger.getLogger(OnlyTimeDependentTravelDisutility.class);
    protected final TravelTime travelTime;

    public OnlyTimeDependentTravelDisutility(TravelTime travelTime) {
        if (travelTime == null) {
            log.warn("TimeCalculator is null so FreeSpeedTravelTimes will be calculated!");
            this.travelTime = new FreeSpeedTravelTime();
        } else {
            this.travelTime = travelTime;
        }
    }

    @Override
    public double getLinkTravelDisutility(Link link, double time, Person person, Vehicle vehicle) {
        return this.travelTime.getLinkTravelTime(link, time, person, vehicle);
    }

    @Override
    public double getLinkMinimumTravelDisutility(Link link) {
        return this.travelTime.getLinkTravelTime(link, Double.NEGATIVE_INFINITY, null, null);
    }
}

