/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.router.costcalculators;

import java.util.Random;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.gbl.MatsimRandom;
import org.matsim.core.router.util.TravelDisutility;
import org.matsim.core.router.util.TravelTime;
import org.matsim.vehicles.Vehicle;

final class RandomizingTimeDistanceTravelDisutility
implements TravelDisutility {
    private final TravelTime timeCalculator;
    private final double marginalCostOfTime;
    private final double marginalCostOfDistance;
    private final double normalization;
    private final double sigma;
    private final Random random;
    private double logNormalRnd;
    private Person prevPerson;

    RandomizingTimeDistanceTravelDisutility(TravelTime timeCalculator, double marginalCostOfTime_s, double marginalCostOfDistance_m, double normalization, double sigma) {
        this.timeCalculator = timeCalculator;
        this.marginalCostOfTime = marginalCostOfTime_s;
        this.marginalCostOfDistance = marginalCostOfDistance_m;
        this.normalization = normalization;
        this.sigma = sigma;
        this.random = sigma != 0.0 ? MatsimRandom.getLocalInstance() : null;
    }

    @Override
    public double getLinkTravelDisutility(Link link, double time, Person person, Vehicle vehicle) {
        if (this.sigma != 0.0) {
            if (person == null) {
                throw new RuntimeException("you cannot use the randomzing travel disutility without person.  If you need this without a person, setsigma to zero.");
            }
            if (person != this.prevPerson) {
                this.prevPerson = person;
                this.logNormalRnd = Math.exp(this.sigma * this.random.nextGaussian());
                this.logNormalRnd *= this.normalization;
            }
            person.getCustomAttributes().put("logNormalRnd", this.logNormalRnd);
        } else {
            this.logNormalRnd = 1.0;
        }
        double travelTime = this.timeCalculator.getLinkTravelTime(link, time, person, vehicle);
        return this.marginalCostOfTime * travelTime + this.logNormalRnd * this.marginalCostOfDistance * link.getLength();
    }

    @Override
    public double getLinkMinimumTravelDisutility(Link link) {
        return link.getLength() / link.getFreespeed() * this.marginalCostOfTime + this.marginalCostOfDistance * link.getLength();
    }
}

