/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.router.costcalculators;

import java.util.Collections;
import java.util.Set;
import org.apache.log4j.Logger;
import org.matsim.core.config.groups.PlanCalcScoreConfigGroup;
import org.matsim.core.router.costcalculators.RandomizingTimeDistanceTravelDisutility;
import org.matsim.core.router.costcalculators.TravelDisutilityFactory;
import org.matsim.core.router.util.TravelDisutility;
import org.matsim.core.router.util.TravelTime;

public class RandomizingTimeDistanceTravelDisutilityFactory
implements TravelDisutilityFactory {
    private static final Logger log = Logger.getLogger(RandomizingTimeDistanceTravelDisutilityFactory.class);
    private static int wrnCnt = 0;
    private static int normalisationWrnCnt = 0;
    private final String mode;
    private double sigma = 0.0;
    private final PlanCalcScoreConfigGroup cnScoringGroup;

    public RandomizingTimeDistanceTravelDisutilityFactory(String mode, PlanCalcScoreConfigGroup cnScoringGroup) {
        this.mode = mode;
        this.cnScoringGroup = cnScoringGroup;
    }

    @Override
    public TravelDisutility createTravelDisutility(TravelTime travelTime) {
        this.logWarningsIfNecessary(this.cnScoringGroup);
        PlanCalcScoreConfigGroup.ModeParams params = this.cnScoringGroup.getModes().get(this.mode);
        if (params == null) {
            throw new NullPointerException(this.mode + " is not part of the valid mode parameters " + this.cnScoringGroup.getModes().keySet());
        }
        double marginalCostOfTime_s = -params.getMarginalUtilityOfTraveling() / 3600.0 + this.cnScoringGroup.getPerforming_utils_hr() / 3600.0;
        double marginalCostOfDistance_m = -params.getMonetaryDistanceRate() * this.cnScoringGroup.getMarginalUtilityOfMoney() - params.getMarginalUtilityOfDistance();
        double normalization = 1.0;
        if (this.sigma != 0.0) {
            normalization = 1.0 / Math.exp(this.sigma * this.sigma / 2.0);
            if (normalisationWrnCnt < 10) {
                ++normalisationWrnCnt;
                log.info(" sigma: " + this.sigma + "; resulting normalization: " + normalization);
            }
        }
        return new RandomizingTimeDistanceTravelDisutility(travelTime, marginalCostOfTime_s, marginalCostOfDistance_m, normalization, this.sigma);
    }

    private void logWarningsIfNecessary(PlanCalcScoreConfigGroup cnScoringGroup) {
        if (wrnCnt < 1) {
            ++wrnCnt;
            if (cnScoringGroup.getModes().get(this.mode).getMonetaryDistanceRate() > 0.0) {
                log.warn("Monetary distance cost rate needs to be NEGATIVE to produce the normal behavior; just found positive.  Continuing anyway.");
            }
            Set<Object> monoSubpopKeyset = Collections.singleton(null);
            if (!cnScoringGroup.getScoringParametersPerSubpopulation().keySet().equals(monoSubpopKeyset)) {
                log.warn("Scoring parameters are defined for different subpopulations. The routing disutility will only consider the ones of the default subpopulation.");
                log.warn("This warning can safely be ignored if disutility of traveling only depends on travel time.");
            }
        }
    }

    public RandomizingTimeDistanceTravelDisutilityFactory setSigma(double val) {
        this.sigma = val;
        return this;
    }
}

