/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.router.priorityqueue;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.matsim.core.router.priorityqueue.HasIndex;
import org.matsim.core.router.priorityqueue.MinHeap;

public class BinaryMinHeap<E extends HasIndex>
implements MinHeap<E> {
    private final E[] data;
    final double[] costs;
    final int[] indices;
    private int heapSize;
    private transient int modCount;
    private final boolean classicalRemove;
    private final int fanout;
    static final int defaultFanout = 6;

    public BinaryMinHeap(int maxSize) {
        this(maxSize, 6, false);
    }

    public BinaryMinHeap(int maxSize, int fanout, boolean classicalRemove) {
        int i;
        this.fanout = fanout;
        this.classicalRemove = classicalRemove;
        this.data = new HasIndex[maxSize];
        this.costs = new double[maxSize];
        for (i = 0; i < this.costs.length; ++i) {
            this.costs[i] = Double.MAX_VALUE;
        }
        this.indices = new int[maxSize];
        for (i = 0; i < this.indices.length; ++i) {
            this.indices[i] = -1;
        }
        this.heapSize = 0;
        this.modCount = 0;
    }

    @Override
    public void reset() {
        int i;
        if (this.heapSize < this.indices.length / 10) {
            for (i = 0; i < this.heapSize; ++i) {
                this.indices[this.getIndex(this.data[i])] = -1;
            }
        } else {
            for (i = 0; i < this.indices.length; ++i) {
                this.indices[i] = -1;
            }
        }
        for (i = 0; i < this.heapSize; ++i) {
            this.costs[i] = Double.MAX_VALUE;
        }
        this.heapSize = 0;
        this.modCount = 0;
    }

    @Override
    public E peek() {
        if (this.isEmpty()) {
            return null;
        }
        return this.peek(0);
    }

    private E peek(int index) {
        return this.data[index];
    }

    @Override
    public E poll() {
        if (this.isEmpty()) {
            return null;
        }
        ++this.modCount;
        E minValue = this.data[0];
        if (this.classicalRemove) {
            this.data[0] = this.data[this.heapSize - 1];
            this.costs[0] = this.costs[this.heapSize - 1];
            this.indices[this.getIndex(this.data[0])] = 0;
            this.indices[this.getIndex(minValue)] = -1;
            --this.heapSize;
            if (this.heapSize > 0) {
                this.siftDown(0);
            }
        } else {
            this.siftDownUp(0);
            this.indices[this.getIndex(minValue)] = -1;
        }
        return minValue;
    }

    private void siftDownUp(int index) {
        index = this.removeSiftDown(index);
        --this.heapSize;
        this.siftUp(index, this.data[this.heapSize], this.costs[this.heapSize]);
        this.costs[this.heapSize] = Double.MAX_VALUE;
    }

    private int removeSiftDown(int nodeIndex) {
        int leftChildIndex;
        while ((leftChildIndex = this.getLeftChildIndex(nodeIndex)) < this.heapSize) {
            double leftCosts = this.costs[leftChildIndex];
            int limitChildIndex = Math.min(leftChildIndex + this.fanout, this.heapSize);
            for (int rightChildIndex = leftChildIndex + 1; rightChildIndex < limitChildIndex; ++rightChildIndex) {
                double rightCosts = this.costs[rightChildIndex];
                if (!(leftCosts >= rightCosts) || !(leftCosts > rightCosts) && this.getIndex((HasIndex)this.data[leftChildIndex]) <= this.getIndex((HasIndex)this.data[rightChildIndex])) continue;
                leftChildIndex = rightChildIndex;
                leftCosts = rightCosts;
            }
            this.copyData(nodeIndex, leftChildIndex);
            nodeIndex = leftChildIndex;
        }
        return nodeIndex;
    }

    @Override
    public int size() {
        return this.heapSize;
    }

    @Override
    public boolean isEmpty() {
        return this.heapSize == 0;
    }

    @Override
    public boolean add(E value, double priority) {
        if (value == null) {
            throw new NullPointerException("null values are not supported!");
        }
        if (this.indices[this.getIndex((HasIndex)value)] >= 0) {
            return false;
        }
        if (this.heapSize == this.data.length) {
            throw new RuntimeException("Heap's underlying storage is overflow!");
        }
        ++this.modCount;
        this.siftUp(this.heapSize, value, priority);
        ++this.heapSize;
        return true;
    }

    @Override
    public boolean remove(E value) {
        if (value == null) {
            return false;
        }
        int index = this.indices[this.getIndex((HasIndex)value)];
        if (index < 0) {
            return false;
        }
        if (this.classicalRemove) {
            boolean decreasedKey = this.decreaseKey(value, Double.NEGATIVE_INFINITY);
            if (decreasedKey && this.data[0] == value) {
                this.poll();
                return true;
            }
            return false;
        }
        this.siftDownUp(index);
        this.indices[this.getIndex(value)] = -1;
        ++this.modCount;
        return true;
    }

    @Override
    public boolean decreaseKey(E value, double cost) {
        int index = this.indices[this.getIndex((HasIndex)value)];
        if (index < 0) {
            return this.add(value, cost);
        }
        double oldCost = this.costs[index];
        if (oldCost < cost) {
            return false;
        }
        this.siftUp(index, value, cost);
        return true;
    }

    @Override
    public Iterator<E> iterator() {
        return new ArrayIterator(this, this.data, this.heapSize);
    }

    private void copyData(int indexTarget, int indexSource) {
        E entry;
        this.data[indexTarget] = entry = this.data[indexSource];
        this.costs[indexTarget] = this.costs[indexSource];
        this.indices[this.getIndex(entry)] = indexTarget;
    }

    private int getLeftChildIndex(int nodeIndex) {
        return this.fanout * nodeIndex + 1;
    }

    private int getParentIndex(int nodeIndex) {
        return (nodeIndex - 1) / this.fanout;
    }

    private void siftUp(int index, E newEntry, double newCost) {
        int parentIndex;
        double parentCost;
        while (!(index <= 0 || newCost > (parentCost = this.costs[parentIndex = this.getParentIndex(index)]) || newCost == parentCost && this.getIndex((HasIndex)newEntry) > this.getIndex((HasIndex)this.data[parentIndex]))) {
            this.copyData(index, parentIndex);
            index = parentIndex;
        }
        this.data[index] = newEntry;
        this.costs[index] = newCost;
        this.indices[this.getIndex(newEntry)] = index;
    }

    private void siftDown(int nodeIndex) {
        int leftChildIndex = this.getLeftChildIndex(nodeIndex);
        if (leftChildIndex >= this.heapSize) {
            return;
        }
        int minIndex = -1;
        double minCosts = Double.POSITIVE_INFINITY;
        int limitChildIndex = Math.min(leftChildIndex + this.fanout, this.heapSize + 1);
        for (int childIndex = leftChildIndex; childIndex < limitChildIndex; ++childIndex) {
            double childCosts = this.costs[childIndex];
            if (!(childCosts <= minCosts) || !(childCosts < minCosts) && this.getIndex((HasIndex)this.data[childIndex]) >= this.getIndex((HasIndex)this.data[minIndex])) continue;
            minIndex = childIndex;
            minCosts = childCosts;
        }
        if (minIndex >= 0) {
            this.swapData(nodeIndex, minIndex);
            this.siftDown(minIndex);
        }
    }

    private void swapData(int index1, int index2) {
        E entry2;
        E entry1 = this.data[index1];
        this.data[index1] = entry2 = this.data[index2];
        this.data[index2] = entry1;
        double tmpCost = this.costs[index1];
        this.costs[index1] = this.costs[index2];
        this.costs[index2] = tmpCost;
        this.indices[this.getIndex(entry1)] = index2;
        this.indices[this.getIndex(entry2)] = index1;
    }

    private int getIndex(HasIndex value) {
        return value.getArrayIndex();
    }

    private final class ArrayIterator
    implements Iterator<E> {
        private final int expectedModCount;
        private final E[] array;
        private final int heapSize;
        private int index;
        final /* synthetic */ BinaryMinHeap this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public ArrayIterator(E[] array, int heapSize) {
            this.this$0 = (BinaryMinHeap)n;
            this.expectedModCount = this.this$0.modCount;
            this.index = 0;
            this.array = array;
            this.heapSize = heapSize;
        }

        @Override
        public boolean hasNext() {
            return this.heapSize > this.index;
        }

        @Override
        public E next() {
            this.checkForComodification();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object value = this.array[this.index];
            ++this.index;
            return value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported operation!");
        }

        private void checkForComodification() {
            if (this.this$0.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

