/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.router.priorityqueue;

import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import org.matsim.core.router.priorityqueue.BinaryMinHeap;
import org.matsim.core.router.priorityqueue.HasIndex;
import org.matsim.core.router.priorityqueue.MinHeap;

public class WrappedBinaryMinHeap<E>
implements MinHeap<E> {
    private final BinaryMinHeap<WrappedEntry> delegate;
    private final Map<E, WrappedEntry> map;

    public WrappedBinaryMinHeap(int maxSize) {
        this.delegate = new BinaryMinHeap(maxSize);
        this.map = new IdentityHashMap<E, WrappedEntry>(maxSize);
    }

    public WrappedBinaryMinHeap(int maxSize, int fanout, boolean classicalRemove) {
        this.delegate = new BinaryMinHeap(maxSize, fanout, classicalRemove);
        this.map = new IdentityHashMap<E, WrappedEntry>(maxSize);
    }

    @Override
    public boolean add(E value, double priority) {
        return this.delegate.add(this.getOrCreateWrappedEntry(value), priority);
    }

    @Override
    public boolean remove(E value) {
        if (value == null) {
            return false;
        }
        return this.delegate.remove(this.getWrappedEntry(value));
    }

    @Override
    public E poll() {
        WrappedEntry entry = (WrappedEntry)this.delegate.poll();
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    @Override
    public boolean decreaseKey(E value, double priority) {
        return this.delegate.decreaseKey(this.getWrappedEntry(value), priority);
    }

    @Override
    public void reset() {
        this.delegate.reset();
    }

    @Override
    public Iterator<E> iterator() {
        return new ArrayIterator(this.delegate.iterator());
    }

    private WrappedEntry getWrappedEntry(E value) {
        if (value == null) {
            throw new NullPointerException("null values are not supported!");
        }
        return this.map.get(value);
    }

    private WrappedEntry getOrCreateWrappedEntry(E value) {
        WrappedEntry wrappedEntry = this.getWrappedEntry(value);
        if (wrappedEntry == null) {
            int index = this.map.size();
            wrappedEntry = new WrappedEntry(value, index);
            this.map.put(value, wrappedEntry);
        }
        return wrappedEntry;
    }

    @Override
    public E peek() {
        WrappedEntry entry = (WrappedEntry)this.delegate.peek();
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    private final class WrappedEntry
    implements HasIndex {
        private final E value;
        private final int index;

        public WrappedEntry(E value, int index) {
            this.value = value;
            this.index = index;
        }

        public E getValue() {
            return this.value;
        }

        @Override
        public int getArrayIndex() {
            return this.index;
        }
    }

    private final class ArrayIterator
    implements Iterator<E> {
        private final Iterator<WrappedEntry> delegate;

        public ArrayIterator(Iterator<WrappedEntry> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public E next() {
            return this.delegate.next().getValue();
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }
    }
}

