/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.router.util;

import java.util.LinkedHashMap;
import java.util.Map;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.NetworkFactory;
import org.matsim.api.core.v01.network.Node;
import org.matsim.core.router.util.RoutingNetwork;
import org.matsim.core.router.util.RoutingNetworkNode;
import org.matsim.utils.objectattributes.attributable.Attributes;

public abstract class AbstractRoutingNetwork
implements RoutingNetwork {
    final Map<Id<Node>, RoutingNetworkNode> nodes = new LinkedHashMap<Id<Node>, RoutingNetworkNode>();
    final Network network;

    public AbstractRoutingNetwork(Network network) {
        this.network = network;
    }

    @Override
    public void initialize() {
    }

    @Override
    public NetworkFactory getFactory() {
        return this.network.getFactory();
    }

    @Override
    public Map<Id<Node>, RoutingNetworkNode> getNodes() {
        return this.nodes;
    }

    public void addNode(RoutingNetworkNode nn) {
        this.nodes.put(nn.getId(), nn);
    }

    @Override
    public RoutingNetworkNode removeNode(Id<Node> nodeId) {
        return this.nodes.remove(nodeId);
    }

    @Override
    public void addLink(Link ll) {
        throw new RuntimeException("Not supported operation!");
    }

    @Override
    public void addNode(Node nn) {
        throw new RuntimeException("Not supported operation!");
    }

    @Override
    public double getCapacityPeriod() {
        throw new RuntimeException("Not supported operation!");
    }

    @Override
    public double getEffectiveLaneWidth() {
        throw new RuntimeException("Not supported operation!");
    }

    @Override
    public Map<Id<Link>, ? extends Link> getLinks() {
        throw new RuntimeException("Not supported operation!");
    }

    @Override
    public Link removeLink(Id<Link> linkId) {
        throw new RuntimeException("Not supported operation!");
    }

    @Override
    public void setCapacityPeriod(double capPeriod) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void setEffectiveCellSize(double effectiveCellSize) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void setEffectiveLaneWidth(double effectiveLaneWidth) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public double getEffectiveCellSize() {
        throw new RuntimeException("not implemented");
    }

    @Override
    public Attributes getAttributes() {
        return this.network.getAttributes();
    }
}

